/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.ZombieHearingSystem;
import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class NodeAlertAllies
extends BehaviorNode {
    private final ZombieHearingSystem hearingSystem;
    private LivingEntity lastTarget = null;
    private int cooldown = 0;
    private static final double CALL_RADIUS = 50.0;

    public NodeAlertAllies(Zombie zombie, ZombieHearingSystem hearingSystem) {
        super(zombie);
        this.hearingSystem = hearingSystem;
    }

    @Override
    public BehaviorStatus tick() {
        LivingEntity target;
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if ((target = this.zombie.m_5448_()) instanceof Player) {
            Player p = (Player)target;
            if (p.f_19797_ < 200 || p.m_7500_() || p.m_5833_()) {
                this.zombie.m_6710_(null);
                this.lastTarget = null;
                return BehaviorStatus.FAILURE;
            }
        }
        if (target == null && this.cooldown == 0) {
            Vec3 noisePos = this.hearingSystem.getNoisePos(this.zombie);
            if (noisePos != null && this.hearingSystem.hasInterestingNoise(this.zombie) && this.zombie.m_20182_().m_82557_(noisePos) > 400.0) {
                this.performScream(noisePos, 0.8f, null);
                return BehaviorStatus.SUCCESS;
            }
            return BehaviorStatus.FAILURE;
        }
        if (target == null) {
            this.lastTarget = null;
            return BehaviorStatus.FAILURE;
        }
        if (target != this.lastTarget) {
            this.lastTarget = target;
            this.performScream(target.m_20182_(), 1.0f, target);
            return BehaviorStatus.SUCCESS;
        }
        if (this.zombie.f_20916_ > 0 && this.cooldown < 80) {
            this.performScream(target.m_20182_(), 1.2f, target);
            return BehaviorStatus.SUCCESS;
        }
        if (this.cooldown == 0 && this.zombie.f_19797_ % 80 == 0 && this.zombie.m_21574_().m_148306_((Entity)target)) {
            this.performScream(target.m_20182_(), 1.0f, target);
            return BehaviorStatus.SUCCESS;
        }
        return BehaviorStatus.FAILURE;
    }

    private void performScream(Vec3 noiseSource, float volume, LivingEntity directTarget) {
        this.cooldown = 100;
        this.zombie.m_9236_().m_6263_(null, this.zombie.m_20185_(), this.zombie.m_20186_(), this.zombie.m_20189_(), SoundEvents.f_12598_, SoundSource.HOSTILE, 5.0f * volume, 0.5f);
        List allies = this.zombie.m_9236_().m_45976_(Zombie.class, this.zombie.m_20191_().m_82400_(50.0));
        for (Zombie ally : allies) {
            if (ally == this.zombie) continue;
            this.hearingSystem.onLoudNoise(ally, noiseSource);
            if (directTarget != null && directTarget.m_6084_() && (ally.m_5448_() == null || ally.m_20280_((Entity)directTarget) > 100.0)) {
                if (directTarget instanceof Player) {
                    Player p = (Player)directTarget;
                    if (p.f_19797_ < 200) continue;
                }
                ally.m_6710_(directTarget);
                ally.m_21561_(true);
                if (!ally.m_6162_() && this.zombie.m_9236_().f_46441_.m_188501_() < 0.4f) {
                    ally.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 120, 0, false, false, false));
                }
            }
            if (!ally.m_21573_().m_26571_()) continue;
            ally.m_21573_().m_26519_(noiseSource.f_82479_, noiseSource.f_82480_, noiseSource.f_82481_, 1.4);
        }
    }
}

