/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class NodeAmbushCoordination
extends BehaviorNode {
    private Vec3 ambushSpot = null;
    private boolean isHiding = false;
    private int patience = 0;

    public NodeAmbushCoordination(Zombie zombie) {
        super(zombie);
    }

    @Override
    public BehaviorStatus tick() {
        LivingEntity target = this.zombie.m_5448_();
        if (target == null) {
            this.reset();
            return BehaviorStatus.FAILURE;
        }
        double distSqr = this.zombie.m_20280_((Entity)target);
        boolean canSeeTarget = this.zombie.m_21574_().m_148306_((Entity)target);
        if (distSqr < 100.0 || canSeeTarget) {
            this.reset();
            return BehaviorStatus.FAILURE;
        }
        if (this.ambushSpot == null && !this.isHiding) {
            this.ambushSpot = this.findAmbushSpot(target);
            if (this.ambushSpot != null) {
                this.zombie.m_21573_().m_26519_(this.ambushSpot.f_82479_, this.ambushSpot.f_82480_, this.ambushSpot.f_82481_, 1.5);
                return BehaviorStatus.RUNNING;
            }
            return BehaviorStatus.FAILURE;
        }
        if (this.ambushSpot != null && !this.isHiding) {
            if (this.zombie.m_20182_().m_82557_(this.ambushSpot) < 4.0) {
                this.isHiding = true;
                this.patience = 200;
                this.zombie.m_20260_(true);
                this.zombie.m_20225_(true);
                this.zombie.m_21573_().m_26573_();
            }
            return BehaviorStatus.RUNNING;
        }
        if (this.isHiding) {
            --this.patience;
            Vec3 toLook = target.m_20182_().m_82546_(this.zombie.m_20182_()).m_82541_();
            this.zombie.m_21563_().m_24946_(this.zombie.m_20185_() + toLook.f_82479_ * 5.0, this.zombie.m_20188_(), this.zombie.m_20189_() + toLook.f_82481_ * 5.0);
            double currentDist = this.zombie.m_20280_((Entity)target);
            if (currentDist < 64.0 || this.patience <= 0) {
                this.performAmbush(target);
                return BehaviorStatus.SUCCESS;
            }
            return BehaviorStatus.RUNNING;
        }
        return BehaviorStatus.FAILURE;
    }

    private Vec3 findAmbushSpot(LivingEntity target) {
        Vec3 targetPos = target.m_20182_();
        Vec3 toTarget = targetPos.m_82546_(this.zombie.m_20182_()).m_82541_();
        for (int dist = 8; dist <= 20; dist += 4) {
            for (int angle = -45; angle <= 45; angle += 15) {
                BlockHitResult hit;
                double rad = Math.toRadians(angle);
                double rotatedX = toTarget.f_82479_ * Math.cos(rad) - toTarget.f_82481_ * Math.sin(rad);
                double rotatedZ = toTarget.f_82479_ * Math.sin(rad) + toTarget.f_82481_ * Math.cos(rad);
                Vec3 candidatePos = this.zombie.m_20182_().m_82520_(rotatedX * (double)dist, 0.0, rotatedZ * (double)dist);
                BlockPos blockPos = new BlockPos((int)candidatePos.f_82479_, (int)this.zombie.m_20186_(), (int)candidatePos.f_82481_);
                if (!this.zombie.m_9236_().m_46859_(blockPos) || !this.zombie.m_9236_().m_46859_(blockPos.m_7494_()) || (hit = this.zombie.m_9236_().m_45547_(new ClipContext(target.m_146892_(), candidatePos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)target))).m_6662_() != HitResult.Type.BLOCK) continue;
                return candidatePos;
            }
        }
        return null;
    }

    private void performAmbush(LivingEntity target) {
        this.zombie.m_20260_(false);
        this.zombie.m_20225_(false);
        this.zombie.m_5496_(SoundEvents.f_12599_, 2.0f, 0.5f);
        this.zombie.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, 1, false, false));
        this.zombie.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 100, 0, false, false));
        this.zombie.m_9236_().m_7605_((Entity)this.zombie, (byte)10);
        List allies = this.zombie.m_9236_().m_45976_(Zombie.class, this.zombie.m_20191_().m_82400_(20.0));
        for (Zombie ally : allies) {
            if (ally == this.zombie) continue;
            if (ally.m_5448_() != target) {
                ally.m_6710_(target);
            }
            ally.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 0, false, false));
        }
        this.zombie.m_21573_().m_5624_((Entity)target, 2.0);
        this.reset();
    }

    @Override
    public void reset() {
        this.ambushSpot = null;
        this.isHiding = false;
        this.patience = 0;
        if (this.zombie.m_6144_()) {
            this.zombie.m_20260_(false);
        }
        this.zombie.m_20225_(false);
    }
}

