/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class NodeAvoidDanger
extends BehaviorNode {
    private int dodgeCooldown = 0;

    public NodeAvoidDanger(Zombie zombie) {
        super(zombie);
    }

    @Override
    public BehaviorStatus tick() {
        List explosives;
        if (this.dodgeCooldown > 0) {
            --this.dodgeCooldown;
        }
        if (this.zombie.m_6060_()) {
            BlockPos water = this.findWater();
            if (water != null) {
                this.zombie.m_21573_().m_26519_((double)water.m_123341_(), (double)water.m_123342_(), (double)water.m_123343_(), 1.6);
                return BehaviorStatus.RUNNING;
            }
            this.randomPanicRun();
            return BehaviorStatus.RUNNING;
        }
        if (this.dodgeCooldown == 0) {
            List projectiles = this.zombie.m_9236_().m_45976_(Projectile.class, this.zombie.m_20191_().m_82400_(4.0));
            for (Projectile p : projectiles) {
                Vec3 vel;
                if (p.m_19749_() instanceof Monster || p.m_20096_() || !((vel = p.m_20184_()).m_82556_() > 0.1)) continue;
                Vec3 toMe = this.zombie.m_20182_().m_82546_(p.m_20182_()).m_82541_();
                if (!(vel.m_82541_().m_82526_(toMe) > 0.9)) continue;
                this.performSmartDodge(vel);
                this.dodgeCooldown = 15;
                return BehaviorStatus.RUNNING;
            }
        }
        if (!(explosives = this.zombie.m_9236_().m_6443_(Entity.class, this.zombie.m_20191_().m_82400_(5.0), e -> {
            Creeper c;
            return e instanceof PrimedTnt || e instanceof Creeper && (c = (Creeper)e).m_32310_() > 0;
        })).isEmpty()) {
            this.fleeFrom(((Entity)explosives.get(0)).m_20182_(), 1.6);
            return BehaviorStatus.RUNNING;
        }
        if (this.checkEnvironmentDanger()) {
            return BehaviorStatus.RUNNING;
        }
        return BehaviorStatus.FAILURE;
    }

    private void performSmartDodge(Vec3 projectileVel) {
        Vec3 right = new Vec3(-projectileVel.f_82481_, 0.0, projectileVel.f_82479_).m_82541_();
        if (this.zombie.m_217043_().m_188499_()) {
            right = right.m_82490_(-1.0);
        }
        double angle = (this.zombie.m_217043_().m_188500_() - 0.5) * 0.5;
        double rx = right.f_82479_ * Math.cos(angle) - right.f_82481_ * Math.sin(angle);
        double rz = right.f_82479_ * Math.sin(angle) + right.f_82481_ * Math.cos(angle);
        Vec3 dodgeDir = new Vec3(rx, 0.0, rz).m_82541_();
        Vec3 forward = projectileVel.m_82490_(-0.4);
        Vec3 finalMove = dodgeDir.m_82549_(forward).m_82541_();
        if (this.zombie.m_20096_()) {
            this.zombie.m_21569_().m_24901_();
        }
        this.zombie.m_20256_(this.zombie.m_20184_().m_82549_(finalMove.m_82490_(0.7)));
        this.zombie.m_21573_().m_26573_();
    }

    private boolean checkEnvironmentDanger() {
        BlockPos origin = this.zombie.m_20183_();
        for (int i = 0; i < 2; ++i) {
            BlockPos pos = i == 0 ? origin : origin.m_121945_(this.zombie.m_6350_());
            BlockState state = this.zombie.m_9236_().m_8055_(pos);
            if (!(state.m_60734_() instanceof LiquidBlock) && !state.m_60713_(Blocks.f_50450_) && !state.m_60713_(Blocks.f_50685_) && !state.m_60713_(Blocks.f_50128_)) continue;
            this.fleeFrom(Vec3.m_82512_((Vec3i)pos), 1.5);
            return true;
        }
        return false;
    }

    private void fleeFrom(Vec3 danger, double speed) {
        Vec3 dir = this.zombie.m_20182_().m_82546_(danger).m_82541_();
        Vec3 dest = this.zombie.m_20182_().m_82549_(dir.m_82490_(4.0));
        this.zombie.m_21573_().m_26519_(dest.f_82479_, dest.f_82480_, dest.f_82481_, speed);
    }

    private void randomPanicRun() {
        if (this.zombie.m_21573_().m_26571_()) {
            double a = this.zombie.m_217043_().m_188500_() * Math.PI * 2.0;
            this.zombie.m_21573_().m_26519_(this.zombie.m_20185_() + Math.cos(a) * 5.0, this.zombie.m_20186_(), this.zombie.m_20189_() + Math.sin(a) * 5.0, 1.5);
        }
    }

    private BlockPos findWater() {
        BlockPos p = this.zombie.m_20183_();
        for (int x = -5; x <= 5; x += 2) {
            for (int z = -5; z <= 5; z += 2) {
                for (int y = -1; y <= 1; ++y) {
                    BlockPos check = p.m_7918_(x, y, z);
                    if (!this.zombie.m_9236_().m_6425_(check).m_205070_(FluidTags.f_13131_)) continue;
                    return check;
                }
            }
        }
        return null;
    }
}

