/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.DeadlyBrainsConfig;
import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.Vec3;

public class NodeAvoidSun
extends BehaviorNode {
    private BlockPos safeSpot;
    private int searchCooldown = 0;

    public NodeAvoidSun(Zombie zombie) {
        super(zombie);
    }

    @Override
    public BehaviorStatus tick() {
        if (!((Boolean)DeadlyBrainsConfig.ZOMBIES_BURN.get()).booleanValue()) {
            return BehaviorStatus.FAILURE;
        }
        if (this.zombie instanceof Drowned) {
            return BehaviorStatus.FAILURE;
        }
        if (!this.zombie.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            return BehaviorStatus.FAILURE;
        }
        if (!this.zombie.m_9236_().m_46461_()) {
            return BehaviorStatus.FAILURE;
        }
        if (this.zombie.m_20069_()) {
            return BehaviorStatus.FAILURE;
        }
        boolean amIBurning = this.zombie.m_9236_().m_45527_(this.zombie.m_20183_());
        if (!amIBurning) {
            LivingEntity target = this.zombie.m_5448_();
            if (target != null && this.zombie.m_9236_().m_45527_(target.m_20183_())) {
                this.zombie.m_21573_().m_26573_();
                this.zombie.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                if (target.m_21205_().m_41720_() instanceof BowItem) {
                    this.retreatDeeper(target);
                }
                return BehaviorStatus.RUNNING;
            }
            this.safeSpot = null;
            return BehaviorStatus.FAILURE;
        }
        this.zombie.m_21573_().m_26517_(1.75);
        if (this.safeSpot != null) {
            if (this.zombie.m_20182_().m_82531_((double)this.safeSpot.m_123341_(), (double)this.safeSpot.m_123342_(), (double)this.safeSpot.m_123343_()) < 2.0) {
                this.safeSpot = null;
                return BehaviorStatus.FAILURE;
            }
            if (this.zombie.m_21573_().m_26571_() && this.zombie.f_19797_ % 20 == 0) {
                this.safeSpot = null;
            } else {
                return BehaviorStatus.RUNNING;
            }
        }
        if (this.searchCooldown-- <= 0) {
            this.searchCooldown = 15;
            this.safeSpot = this.findBestShelter();
            if (this.safeSpot != null) {
                this.zombie.m_21573_().m_26519_((double)this.safeSpot.m_123341_(), (double)this.safeSpot.m_123342_(), (double)this.safeSpot.m_123343_(), 1.75);
                return BehaviorStatus.RUNNING;
            }
        }
        if (this.zombie.m_21573_().m_26571_()) {
            this.randomRun();
        }
        return BehaviorStatus.RUNNING;
    }

    private void retreatDeeper(LivingEntity target) {
        if (this.zombie.f_19797_ % 10 != 0) {
            return;
        }
        Vec3 dirAway = this.zombie.m_20182_().m_82546_(target.m_20182_()).m_82541_();
        Vec3 retreatPos = this.zombie.m_20182_().m_82549_(dirAway.m_82490_(5.0));
        if (this.zombie.m_9236_().m_46859_(BlockPos.m_274446_((Position)retreatPos))) {
            this.zombie.m_21573_().m_26519_(retreatPos.f_82479_, retreatPos.f_82480_, retreatPos.f_82481_, 1.3);
        }
    }

    private BlockPos findBestShelter() {
        BlockPos origin = this.zombie.m_20183_();
        LevelLightEngine le = this.zombie.m_9236_().m_5518_();
        BlockPos best = null;
        double bestScore = Double.MAX_VALUE;
        for (int x = -25; x <= 25; x += 3) {
            for (int z = -25; z <= 25; z += 3) {
                for (int y = -10; y <= 5; y += 2) {
                    boolean isShade;
                    BlockPos pos = origin.m_7918_(x, y, z);
                    boolean isWater = this.zombie.m_9236_().m_6425_(pos).m_205070_(FluidTags.f_13131_);
                    boolean bl = isShade = !this.zombie.m_9236_().m_45527_(pos) && le.m_75831_(pos, 0) < 12 && this.zombie.m_9236_().m_8055_(pos.m_7495_()).m_280296_() && this.zombie.m_9236_().m_46859_(pos) && this.zombie.m_9236_().m_46859_(pos.m_7494_());
                    if (!isWater && !isShade) continue;
                    double dist = origin.m_123331_((Vec3i)pos);
                    double yDiff = origin.m_123342_() - pos.m_123342_();
                    double score = dist - yDiff * 20.0;
                    if (isWater) {
                        score -= 100.0;
                    }
                    if (!(score < bestScore)) continue;
                    bestScore = score;
                    best = pos;
                }
            }
        }
        return best;
    }

    private void randomRun() {
        double randX = this.zombie.m_20185_() + (this.zombie.m_217043_().m_188500_() - 0.5) * 15.0;
        double randZ = this.zombie.m_20189_() + (this.zombie.m_217043_().m_188500_() - 0.5) * 15.0;
        this.zombie.m_21573_().m_26519_(randX, this.zombie.m_20186_(), randZ, 1.6);
    }
}

