/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;

public class NodeBloodScent
extends BehaviorNode {
    private int checkTimer = 0;

    public NodeBloodScent(Zombie zombie) {
        super(zombie);
    }

    @Override
    public BehaviorStatus tick() {
        if (this.checkTimer++ % 40 != 0) {
            return BehaviorStatus.FAILURE;
        }
        LivingEntity currentTarget = this.zombie.m_5448_();
        if (currentTarget instanceof Player) {
            Player p = (Player)currentTarget;
            if (p.f_19797_ < 200 || !p.m_6084_() || p.m_7500_()) {
                this.zombie.m_6710_(null);
                return BehaviorStatus.FAILURE;
            }
            this.applyBloodlust(p);
            return BehaviorStatus.FAILURE;
        }
        Player victim = this.zombie.m_9236_().m_45930_((Entity)this.zombie, 60.0);
        if (victim != null && !victim.m_7500_() && !victim.m_5833_()) {
            float maxHealth;
            if (victim.f_19797_ < 200) {
                return BehaviorStatus.FAILURE;
            }
            float health = victim.m_21223_();
            if ((double)health >= (double)(maxHealth = victim.m_21233_()) * 0.9) {
                return BehaviorStatus.FAILURE;
            }
            double detectionRange = (double)(maxHealth - health) * 3.5;
            if (this.zombie.m_20280_((Entity)victim) < detectionRange * detectionRange) {
                this.zombie.m_6710_((LivingEntity)victim);
                this.zombie.m_5496_(SoundEvents.f_12609_, 1.0f, 0.5f);
                this.applyBloodlust(victim);
                return BehaviorStatus.SUCCESS;
            }
        }
        return BehaviorStatus.FAILURE;
    }

    private void applyBloodlust(Player target) {
        if (this.zombie.m_6162_()) {
            return;
        }
        float health = target.m_21223_();
        if (health < 10.0f) {
            this.zombie.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 0, false, false, false));
        }
        if (health < 6.0f) {
            this.zombie.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 1, false, false, false));
            this.zombie.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 60, 0, false, false, false));
        }
    }
}

