/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.phys.Vec3;

public class NodeCombatWithLunge
extends BehaviorNode {
    private int lungeCooldown = 0;
    private int windupTimer = 0;
    private boolean isWindingUp = false;
    private boolean isLunging = false;
    private int strafeTimer = 0;
    private boolean strafeDir = false;
    private int shieldBashCooldown = 0;

    public NodeCombatWithLunge(Zombie zombie) {
        super(zombie);
    }

    @Override
    public BehaviorStatus tick() {
        double reach;
        LivingEntity target = this.zombie.m_5448_();
        if (target == null || !target.m_6084_()) {
            return BehaviorStatus.FAILURE;
        }
        double distSqr = this.zombie.m_20280_((Entity)target);
        if (distSqr <= (reach = (double)(this.zombie.m_20205_() * 2.0f * this.zombie.m_20205_() * 2.0f + target.m_20205_())) + 2.0) {
            this.zombie.m_7327_((Entity)target);
            this.zombie.m_6674_(InteractionHand.MAIN_HAND);
            return BehaviorStatus.SUCCESS;
        }
        if (this.lungeCooldown > 0) {
            --this.lungeCooldown;
        }
        if (this.shieldBashCooldown > 0) {
            --this.shieldBashCooldown;
        }
        if (target.m_21254_() && this.isLookingAtMe(target)) {
            if (distSqr < 16.0 && this.shieldBashCooldown == 0 && this.zombie.m_20096_()) {
                this.performShieldBash(target);
                return BehaviorStatus.RUNNING;
            }
            if (distSqr < 25.0 && this.lungeCooldown == 0 && this.zombie.m_20096_()) {
                this.performJumpOver(target);
                return BehaviorStatus.RUNNING;
            }
            this.performShieldStrafe(target);
            return BehaviorStatus.RUNNING;
        }
        if (!this.isLunging && !this.isWindingUp && this.lungeCooldown == 0 && distSqr > 25.0 && distSqr < 100.0 && this.zombie.m_20096_() && this.zombie.m_21574_().m_148306_((Entity)target) && this.zombie.m_217043_().m_188501_() < 0.3f) {
            this.isWindingUp = true;
            this.windupTimer = 5;
            this.zombie.m_5496_(SoundEvents.f_12609_, 1.0f, 0.5f);
        }
        if (this.isWindingUp) {
            this.zombie.m_21573_().m_26573_();
            this.zombie.m_21563_().m_24960_((Entity)target, 100.0f, 100.0f);
            if (--this.windupTimer <= 0) {
                this.performLunge(target);
                this.isWindingUp = false;
            }
            return BehaviorStatus.RUNNING;
        }
        if (this.isLunging) {
            if (this.zombie.m_20096_() && this.lungeCooldown < 55) {
                this.isLunging = false;
            }
            this.zombie.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            return BehaviorStatus.RUNNING;
        }
        this.zombie.m_21573_().m_5624_((Entity)target, 1.3);
        return BehaviorStatus.RUNNING;
    }

    private void performLunge(LivingEntity target) {
        this.isLunging = true;
        this.lungeCooldown = 55;
        Vec3 toTarget = target.m_20182_().m_82546_(this.zombie.m_20182_());
        Vec3 targetVelocity = target.m_20184_();
        double predictionTime = toTarget.m_82553_() / 2.0;
        Vec3 predictedPos = target.m_20182_().m_82549_(targetVelocity.m_82490_(predictionTime * 20.0));
        Vec3 finalDir = predictedPos.m_82546_(this.zombie.m_20182_()).m_82541_();
        double distance = Math.sqrt(this.zombie.m_20280_((Entity)target));
        double powerH = Math.min(1.5, distance * 0.25);
        double powerV = 0.4 + distance * 0.02;
        this.zombie.m_20334_(finalDir.f_82479_ * powerH, powerV, finalDir.f_82481_ * powerH);
        this.zombie.m_5496_(SoundEvents.f_12600_, 0.5f, 1.0f);
    }

    private void performShieldBash(LivingEntity target) {
        this.isLunging = true;
        this.lungeCooldown = 35;
        this.shieldBashCooldown = 80;
        Vec3 toTarget = target.m_20182_().m_82546_(this.zombie.m_20182_()).m_82541_();
        this.zombie.m_20334_(toTarget.f_82479_ * 1.0, 0.45, toTarget.f_82481_ * 1.0);
        this.zombie.m_5496_(SoundEvents.f_12057_, 1.0f, 0.7f);
        if (this.zombie.m_20280_((Entity)target) < 4.0) {
            target.m_6469_(this.zombie.m_9236_().m_269111_().m_269333_((LivingEntity)this.zombie), 2.0f);
        }
    }

    private void performJumpOver(LivingEntity target) {
        this.isLunging = true;
        this.lungeCooldown = 40;
        Vec3 toTarget = target.m_20182_().m_82546_(this.zombie.m_20182_()).m_82541_();
        this.zombie.m_20334_(toTarget.f_82479_ * 0.9, 0.6, toTarget.f_82481_ * 0.9);
        this.zombie.m_5496_(SoundEvents.f_12622_, 1.0f, 0.5f);
    }

    private void performShieldStrafe(LivingEntity target) {
        if (this.strafeTimer-- <= 0) {
            this.strafeTimer = 8;
            this.strafeDir = !this.strafeDir;
        }
        Vec3 forward = target.m_20182_().m_82546_(this.zombie.m_20182_()).m_82541_();
        Vec3 right = new Vec3(-forward.f_82481_, 0.0, forward.f_82479_);
        Vec3 move = this.strafeDir ? right : right.m_82490_(-1.0);
        Vec3 finalMove = move.m_82490_(2.8).m_82549_(forward.m_82490_(0.7));
        this.zombie.m_21573_().m_26519_(this.zombie.m_20185_() + finalMove.f_82479_, this.zombie.m_20186_(), this.zombie.m_20189_() + finalMove.f_82481_, 1.6);
        this.zombie.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
    }

    private boolean isLookingAtMe(LivingEntity target) {
        Vec3 toZombie;
        Vec3 targetLook = target.m_20154_().m_82541_();
        return targetLook.m_82526_(toZombie = this.zombie.m_20182_().m_82546_(target.m_20182_()).m_82541_()) > 0.5;
    }

    @Override
    public void reset() {
        this.isWindingUp = false;
        this.isLunging = false;
    }
}

