/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class NodeInvestigateLight
extends BehaviorNode {
    private BlockPos lightTarget;
    private int cooldown = 0;
    private int breakTimer = 0;
    private final Set<BlockPos> unreachableTargets = new HashSet<BlockPos>();
    private int blacklistClearTimer = 0;

    public NodeInvestigateLight(Zombie zombie) {
        super(zombie);
        this.cooldown = zombie.m_217043_().m_188503_(100);
    }

    @Override
    public BehaviorStatus tick() {
        if (this.blacklistClearTimer++ > 600) {
            this.unreachableTargets.clear();
            this.blacklistClearTimer = 0;
        }
        if (this.zombie.m_5448_() != null) {
            return BehaviorStatus.FAILURE;
        }
        if (this.zombie.m_9236_().m_46461_() && this.zombie.m_9236_().m_45527_(this.zombie.m_20183_())) {
            return BehaviorStatus.FAILURE;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return BehaviorStatus.FAILURE;
        }
        if (this.lightTarget != null) {
            double distSqr = this.zombie.m_20182_().m_82531_((double)this.lightTarget.m_123341_(), (double)this.lightTarget.m_123342_(), (double)this.lightTarget.m_123343_());
            double yDiff = Math.abs((double)this.lightTarget.m_123342_() - this.zombie.m_20186_());
            if (distSqr < 12.0 && yDiff < 3.5) {
                this.zombie.m_21573_().m_26573_();
                this.zombie.m_21563_().m_24946_((double)this.lightTarget.m_123341_(), (double)this.lightTarget.m_123342_(), (double)this.lightTarget.m_123343_());
                if (this.zombie.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                    ++this.breakTimer;
                    if (this.breakTimer % 5 == 0) {
                        this.zombie.m_6674_(InteractionHand.MAIN_HAND);
                    }
                    if (this.breakTimer > 20) {
                        this.zombie.m_9236_().m_46961_(this.lightTarget, true);
                        this.zombie.m_5496_(SoundEvents.f_12601_, 1.0f, 1.0f);
                        this.lightTarget = null;
                        this.breakTimer = 0;
                        return BehaviorStatus.SUCCESS;
                    }
                    return BehaviorStatus.RUNNING;
                }
                this.lightTarget = null;
                this.cooldown = 200;
                return BehaviorStatus.SUCCESS;
            }
            if ((this.zombie.m_21573_().m_26571_() || this.zombie.m_21573_().m_26577_()) && distSqr > 12.0) {
                this.unreachableTargets.add(this.lightTarget);
                this.lightTarget = null;
                this.cooldown = 60;
                return BehaviorStatus.FAILURE;
            }
            return BehaviorStatus.RUNNING;
        }
        if ((this.zombie.f_19797_ + this.zombie.m_19879_()) % 100 == 0) {
            this.lightTarget = this.findArtificialLight();
            if (this.lightTarget != null) {
                boolean pathFound = this.zombie.m_21573_().m_26519_((double)this.lightTarget.m_123341_(), (double)this.lightTarget.m_123342_(), (double)this.lightTarget.m_123343_(), 1.0);
                if (!pathFound) {
                    this.unreachableTargets.add(this.lightTarget);
                    this.lightTarget = null;
                } else {
                    return BehaviorStatus.RUNNING;
                }
            }
        }
        return BehaviorStatus.FAILURE;
    }

    private BlockPos findArtificialLight() {
        BlockPos origin = this.zombie.m_20183_();
        for (int x = -30; x <= 30; x += 5) {
            for (int z = -30; z <= 30; z += 5) {
                for (int y = -5; y <= 5; y += 3) {
                    BlockState state;
                    BlockPos pos = origin.m_7918_(x, y, z);
                    if (this.unreachableTargets.contains(pos) || !this.zombie.m_9236_().m_46749_(pos) || this.zombie.m_9236_().m_45517_(LightLayer.BLOCK, pos) <= 9 || (state = this.zombie.m_9236_().m_8055_(pos)).m_60713_(Blocks.f_49991_) || state.m_60713_(Blocks.f_50083_) || state.m_60713_(Blocks.f_50084_) || state.m_60713_(Blocks.f_50450_) || state.m_60713_(Blocks.f_50683_) || state.m_60713_(Blocks.f_50684_) || state.m_60713_(Blocks.f_152475_)) continue;
                    return pos;
                }
            }
        }
        return null;
    }
}

