/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.ZombieHearingSystem;
import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.phys.Vec3;

public class NodeInvestigateNoise
extends BehaviorNode {
    private final ZombieHearingSystem hearingSystem;
    private int searchTimer = 0;
    private boolean isSearching = false;

    public NodeInvestigateNoise(Zombie zombie, ZombieHearingSystem hearingSystem) {
        super(zombie);
        this.hearingSystem = hearingSystem;
    }

    @Override
    public BehaviorStatus tick() {
        if (this.zombie.m_5448_() != null) {
            this.isSearching = false;
            return BehaviorStatus.FAILURE;
        }
        Vec3 noisePos = this.hearingSystem.getNoisePos(this.zombie);
        if (noisePos == null) {
            return BehaviorStatus.FAILURE;
        }
        double distSqr = this.zombie.m_20182_().m_82557_(noisePos);
        if (!this.isSearching) {
            if (distSqr > 9.0) {
                boolean pathFound;
                if ((this.zombie.m_21573_().m_26571_() || this.zombie.f_19797_ % 20 == 0) && !(pathFound = this.zombie.m_21573_().m_26519_(noisePos.f_82479_, noisePos.f_82480_, noisePos.f_82481_, 1.2)) && this.zombie.f_19797_ % 40 == 0) {
                    this.hearingSystem.clearNoise(this.zombie);
                    return BehaviorStatus.FAILURE;
                }
                return BehaviorStatus.RUNNING;
            }
            this.isSearching = true;
            this.searchTimer = 100;
            this.zombie.m_21573_().m_26573_();
            this.zombie.m_5496_(SoundEvents.f_12598_, 1.0f, 0.5f);
        }
        if (this.isSearching) {
            --this.searchTimer;
            if (this.searchTimer <= 0) {
                this.hearingSystem.clearNoise(this.zombie);
                this.isSearching = false;
                return BehaviorStatus.SUCCESS;
            }
            if (this.searchTimer % 20 == 0) {
                double randX = noisePos.f_82479_ + (this.zombie.m_217043_().m_188500_() - 0.5) * 6.0;
                double randZ = noisePos.f_82481_ + (this.zombie.m_217043_().m_188500_() - 0.5) * 6.0;
                this.zombie.m_21563_().m_24946_(randX, this.zombie.m_20188_(), randZ);
            }
            if (this.zombie.m_21573_().m_26571_() && this.searchTimer % 40 == 0) {
                double offsetX = (this.zombie.m_217043_().m_188500_() - 0.5) * 4.0;
                double offsetZ = (this.zombie.m_217043_().m_188500_() - 0.5) * 4.0;
                this.zombie.m_21573_().m_26519_(noisePos.f_82479_ + offsetX, noisePos.f_82480_, noisePos.f_82481_ + offsetZ, 0.8);
            }
            return BehaviorStatus.RUNNING;
        }
        return BehaviorStatus.FAILURE;
    }
}

