/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.ZombieSquadManager;
import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;

public class NodeLeaderSupport
extends BehaviorNode {
    private int buffTimer = 0;
    private final boolean isLeaderType;

    public NodeLeaderSupport(Zombie zombie) {
        super(zombie);
        boolean hasHelmet = !zombie.m_6844_(EquipmentSlot.HEAD).m_41619_();
        this.isLeaderType = hasHelmet || ZombieSquadManager.isLeader(zombie);
    }

    @Override
    public BehaviorStatus tick() {
        if (!this.isLeaderType) {
            return BehaviorStatus.FAILURE;
        }
        if (this.buffTimer++ >= 60) {
            this.buffTimer = 0;
            this.applyCommandAura();
        }
        return BehaviorStatus.FAILURE;
    }

    private void applyCommandAura() {
        if (!this.zombie.m_6084_()) {
            return;
        }
        this.zombie.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.zombie.m_20185_(), this.zombie.m_20188_() + 0.5, this.zombie.m_20189_(), 0.0, 0.0, 0.0);
        this.zombie.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 80, 0, true, false));
        List squad = this.zombie.m_9236_().m_45976_(Zombie.class, this.zombie.m_20191_().m_82400_(15.0));
        LivingEntity leaderTarget = this.zombie.m_5448_();
        if (leaderTarget != null && this.zombie.m_217043_().m_188503_(5) == 0) {
            this.zombie.m_5496_(SoundEvents.f_12598_, 1.5f, 0.5f);
        }
        for (Zombie ally : squad) {
            if (ally == this.zombie) continue;
            ally.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, 0, true, false));
            ally.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 100, 0, true, false));
            if (leaderTarget == null || ally.m_5448_() != null) continue;
            ally.m_6710_(leaderTarget);
            ally.m_9236_().m_7605_((Entity)ally, (byte)10);
        }
    }
}

