/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.ZombieHearingSystem;
import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class NodeMemoryScent
extends BehaviorNode {
    private final ZombieHearingSystem hearingSystem;
    private Vec3 lastKnownPos;
    private int lostTimer = 0;

    public NodeMemoryScent(Zombie zombie, ZombieHearingSystem hearingSystem) {
        super(zombie);
        this.hearingSystem = hearingSystem;
    }

    @Override
    public BehaviorStatus tick() {
        LivingEntity target;
        Player nearbyPlayer = this.zombie.m_9236_().m_45930_((Entity)this.zombie, 20.0);
        if (nearbyPlayer != null && !nearbyPlayer.m_7500_() && !nearbyPlayer.m_5833_()) {
            boolean isInvisible = nearbyPlayer.m_20145_();
            boolean shouldDetect = false;
            if (!isInvisible) {
                shouldDetect = true;
            }
            if (isInvisible) {
                if (this.hasArmor(nearbyPlayer)) {
                    shouldDetect = true;
                }
                if (nearbyPlayer.m_20142_()) {
                    shouldDetect = true;
                }
                if (nearbyPlayer.m_6060_() || nearbyPlayer.m_20069_()) {
                    shouldDetect = true;
                }
                if ((double)nearbyPlayer.m_21223_() < (double)nearbyPlayer.m_21233_() * 0.5) {
                    shouldDetect = true;
                }
            }
            if (shouldDetect) {
                if (this.zombie.m_5448_() != nearbyPlayer) {
                    this.zombie.m_6710_((LivingEntity)nearbyPlayer);
                }
                this.lastKnownPos = nearbyPlayer.m_20182_();
                this.lostTimer = 0;
            }
        }
        if ((target = this.zombie.m_5448_()) != null && this.zombie.m_21574_().m_148306_((Entity)target)) {
            this.lastKnownPos = target.m_20182_();
            this.lostTimer = 0;
            return BehaviorStatus.FAILURE;
        }
        if (!(target != null && this.zombie.m_21574_().m_148306_((Entity)target) || this.lastKnownPos == null)) {
            this.zombie.m_21573_().m_26519_(this.lastKnownPos.f_82479_, this.lastKnownPos.f_82480_, this.lastKnownPos.f_82481_, 1.3);
            if (this.zombie.m_20182_().m_82557_(this.lastKnownPos) < 4.0) {
                if (this.lostTimer++ > 100) {
                    this.lastKnownPos = null;
                    this.zombie.m_6710_(null);
                } else {
                    this.zombie.m_21573_().m_26573_();
                    double lookX = this.lastKnownPos.f_82479_ + (this.zombie.m_217043_().m_188500_() - 0.5) * 10.0;
                    double lookZ = this.lastKnownPos.f_82481_ + (this.zombie.m_217043_().m_188500_() - 0.5) * 10.0;
                    this.zombie.m_21563_().m_24946_(lookX, this.zombie.m_20188_(), lookZ);
                }
            }
            return BehaviorStatus.RUNNING;
        }
        Vec3 noise = this.hearingSystem.getNoisePos(this.zombie);
        if (noise != null) {
            if (this.zombie.m_20182_().m_82557_(noise) > 4.0) {
                this.zombie.m_21573_().m_26519_(noise.f_82479_, noise.f_82480_, noise.f_82481_, 1.25);
                return BehaviorStatus.RUNNING;
            }
            this.hearingSystem.clearNoise(this.zombie);
        }
        return BehaviorStatus.FAILURE;
    }

    private boolean hasArmor(Player p) {
        return !p.m_6844_(EquipmentSlot.HEAD).m_41619_() || !p.m_6844_(EquipmentSlot.CHEST).m_41619_() || !p.m_6844_(EquipmentSlot.LEGS).m_41619_() || !p.m_6844_(EquipmentSlot.FEET).m_41619_();
    }
}

