/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.DeadlyBrainsConfig;
import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class NodePatrolAndCamp
extends BehaviorNode {
    private BlockPos campCenter;
    private int timer = 0;
    private int stuckCounter = 0;
    private Vec3 lastPos;
    private int separationTimer = 0;

    public NodePatrolAndCamp(Zombie zombie) {
        super(zombie);
        this.campCenter = zombie.m_20183_();
        this.lastPos = zombie.m_20182_();
    }

    @Override
    public BehaviorStatus tick() {
        Vec3 separation;
        boolean isUnderRoof;
        if (this.zombie.m_5448_() != null) {
            if (this.zombie.f_19797_ % 100 == 0) {
                this.campCenter = this.zombie.m_20183_();
            }
            if (this.zombie.m_6144_()) {
                this.zombie.m_20260_(false);
            }
            return BehaviorStatus.FAILURE;
        }
        boolean isDay = this.zombie.m_9236_().m_46461_();
        boolean isDrowned = this.zombie instanceof Drowned;
        boolean bl = isUnderRoof = !this.zombie.m_9236_().m_45527_(this.zombie.m_20183_());
        if (!isDrowned && isDay && !isUnderRoof) {
            return BehaviorStatus.FAILURE;
        }
        if (this.separationTimer++ % 10 == 0 && (separation = this.calculateSeparation()) != null) {
            this.zombie.m_20256_(this.zombie.m_20184_().m_82549_(separation.m_82490_(0.05)));
        }
        if (this.zombie.m_20182_().m_82557_(this.lastPos) < 0.05) {
            ++this.stuckCounter;
            if (this.stuckCounter > 40) {
                this.campCenter = this.zombie.m_20183_();
                this.timer = 0;
                this.stuckCounter = 0;
                double randX = (this.zombie.m_217043_().m_188500_() - 0.5) * 2.0;
                double randZ = (this.zombie.m_217043_().m_188500_() - 0.5) * 2.0;
                this.zombie.m_20256_(this.zombie.m_20184_().m_82520_(randX, 0.0, randZ));
            }
        } else {
            this.stuckCounter = 0;
        }
        this.lastPos = this.zombie.m_20182_();
        if (this.timer-- <= 0) {
            double patrolRadius;
            Vec3 target;
            this.timer = 80 + this.zombie.m_217043_().m_188503_(80);
            if (this.zombie.m_21573_().m_26571_() && (target = this.getWanderTarget(patrolRadius = ((Double)DeadlyBrainsConfig.PATROL_RADIUS.get()).doubleValue(), isDrowned)) != null) {
                this.zombie.m_21573_().m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, 0.95);
                this.zombie.m_20260_(false);
            }
        }
        if (this.zombie.m_21573_().m_26571_()) {
            if (!isDrowned && !this.zombie.m_20069_()) {
                if (!this.zombie.m_6144_() && this.zombie.m_217043_().m_188503_(200) == 0) {
                    this.zombie.m_20260_(true);
                }
                if (this.zombie.m_6144_() && this.zombie.m_217043_().m_188503_(100) == 0) {
                    this.zombie.m_20260_(false);
                }
            }
            if (this.zombie.f_19797_ % 60 == 0) {
                double lookX = this.zombie.m_20185_() + (this.zombie.m_217043_().m_188500_() - 0.5) * 15.0;
                double lookZ = this.zombie.m_20189_() + (this.zombie.m_217043_().m_188500_() - 0.5) * 15.0;
                this.zombie.m_21563_().m_24946_(lookX, this.zombie.m_20188_(), lookZ);
            }
        }
        return BehaviorStatus.RUNNING;
    }

    private Vec3 calculateSeparation() {
        List neighbors = this.zombie.m_9236_().m_45976_(Zombie.class, this.zombie.m_20191_().m_82400_(2.0));
        if (neighbors.size() <= 1) {
            return null;
        }
        Vec3 push = Vec3.f_82478_;
        int count = 0;
        for (Zombie other : neighbors) {
            double dist;
            if (other == this.zombie || !((dist = this.zombie.m_20280_((Entity)other)) < 4.0)) continue;
            Vec3 away = this.zombie.m_20182_().m_82546_(other.m_20182_()).m_82541_();
            double force = (4.0 - dist) / 4.0;
            push = push.m_82549_(away.m_82490_(force));
            ++count;
        }
        return count > 0 ? push.m_82541_() : null;
    }

    private Vec3 getWanderTarget(double range, boolean isDrowned) {
        for (int i = 0; i < 15; ++i) {
            double angle = this.zombie.m_217043_().m_188500_() * Math.PI * 2.0;
            double dist = 8.0 + this.zombie.m_217043_().m_188500_() * range;
            int tx = this.campCenter.m_123341_() + (int)(Math.cos(angle) * dist);
            int tz = this.campCenter.m_123343_() + (int)(Math.sin(angle) * dist);
            int ty = isDrowned ? this.zombie.m_9236_().m_6924_(Heightmap.Types.OCEAN_FLOOR, tx, tz) : this.zombie.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, tx, tz);
            BlockPos targetPos = new BlockPos(tx, ty, tz);
            if (isDrowned) {
                if (!this.zombie.m_9236_().m_6425_(targetPos).m_205070_(FluidTags.f_13131_) && !this.zombie.m_9236_().m_6425_(targetPos.m_7494_()).m_205070_(FluidTags.f_13131_)) continue;
                return new Vec3((double)tx, (double)ty, (double)tz);
            }
            double yDiff = Math.abs((double)ty - this.zombie.m_20186_());
            boolean hasWater = this.zombie.m_9236_().m_6425_(targetPos).m_205070_(FluidTags.f_13131_);
            boolean hasFloor = this.zombie.m_9236_().m_8055_(targetPos.m_7495_()).m_280296_();
            if (!(yDiff < 6.0) || hasWater || !hasFloor) continue;
            return new Vec3((double)tx, (double)ty, (double)tz);
        }
        return null;
    }
}

