/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.phys.Vec3;

public class NodePlayDead
extends BehaviorNode {
    private boolean isPlayingDead = false;
    private int patience = 0;

    public NodePlayDead(Zombie zombie) {
        super(zombie);
    }

    @Override
    public BehaviorStatus tick() {
        LivingEntity target = this.zombie.m_5448_();
        if (target == null) {
            this.reset();
            return BehaviorStatus.FAILURE;
        }
        float healthPercent = this.zombie.m_21223_() / this.zombie.m_21233_();
        double distSqr = this.zombie.m_20280_((Entity)target);
        if (!this.isPlayingDead && healthPercent < 0.5f && distSqr > 25.0 && distSqr < 225.0 && this.zombie.m_217043_().m_188501_() < 0.2f) {
            this.startPlayingDead();
            return BehaviorStatus.RUNNING;
        }
        if (this.isPlayingDead) {
            --this.patience;
            this.zombie.m_21563_().m_24946_(this.zombie.m_20185_(), this.zombie.m_20186_() - 2.0, this.zombie.m_20189_());
            double currentDist = this.zombie.m_20280_((Entity)target);
            if (currentDist < 16.0 || this.patience <= 0) {
                this.performJumpScare(target);
                return BehaviorStatus.SUCCESS;
            }
            if (currentDist > 400.0) {
                this.reset();
                return BehaviorStatus.FAILURE;
            }
            return BehaviorStatus.RUNNING;
        }
        return BehaviorStatus.FAILURE;
    }

    private void startPlayingDead() {
        this.isPlayingDead = true;
        this.patience = 300;
        this.zombie.m_20260_(true);
        this.zombie.m_20225_(true);
        this.zombie.m_21573_().m_26573_();
        this.zombie.m_5496_(SoundEvents.f_12608_, 0.5f, 0.8f);
    }

    private void performJumpScare(LivingEntity target) {
        this.zombie.m_20260_(false);
        this.zombie.m_20225_(false);
        this.zombie.m_5496_(SoundEvents.f_12599_, 2.5f, 0.3f);
        if (this.zombie.m_20096_()) {
            Vec3 toTarget = target.m_20182_().m_82546_(this.zombie.m_20182_()).m_82541_();
            this.zombie.m_20334_(toTarget.f_82479_ * 1.2, 0.5, toTarget.f_82481_ * 1.2);
        }
        this.zombie.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 2, false, false));
        this.zombie.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 60, 1, false, false));
        this.zombie.m_9236_().m_7605_((Entity)this.zombie, (byte)10);
        this.reset();
    }

    @Override
    public void reset() {
        this.isPlayingDead = false;
        this.patience = 0;
        if (this.zombie.m_6144_()) {
            this.zombie.m_20260_(false);
        }
        this.zombie.m_20225_(false);
    }
}

