/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;

public class NodeScavengeLoot
extends BehaviorNode {
    private int scanTimer = 0;

    public NodeScavengeLoot(Zombie zombie) {
        super(zombie);
    }

    @Override
    public BehaviorStatus tick() {
        if (this.scanTimer++ % 60 != 0) {
            return BehaviorStatus.FAILURE;
        }
        List items = this.zombie.m_9236_().m_45976_(ItemEntity.class, this.zombie.m_20191_().m_82400_(2.5));
        if (items.isEmpty()) {
            return BehaviorStatus.FAILURE;
        }
        for (ItemEntity entity : items) {
            ItemStack stack = entity.m_32055_();
            if (stack.m_41619_()) continue;
            if (this.zombie.m_21223_() < this.zombie.m_21233_() && stack.m_41614_()) {
                this.zombie.m_5634_(4.0f);
                this.zombie.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                this.zombie.m_9236_().m_7605_((Entity)this.zombie, (byte)10);
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    entity.m_146870_();
                }
                return BehaviorStatus.SUCCESS;
            }
            if (!this.isBetterGear(stack)) continue;
            this.equipItem(stack);
            entity.m_146870_();
            this.zombie.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
            return BehaviorStatus.SUCCESS;
        }
        return BehaviorStatus.FAILURE;
    }

    private boolean isBetterGear(ItemStack stack) {
        boolean isWeapon;
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            EquipmentSlot slot = armor.m_40402_();
            ItemStack current = this.zombie.m_6844_(slot);
            if (current.m_41619_()) {
                return true;
            }
            Item item2 = current.m_41720_();
            if (item2 instanceof ArmorItem) {
                ArmorItem currentArmor = (ArmorItem)item2;
                return armor.m_40404_() > currentArmor.m_40404_();
            }
        }
        boolean bl = isWeapon = stack.m_41720_() instanceof SwordItem || stack.m_41720_() instanceof DiggerItem;
        if (isWeapon) {
            double curDmg;
            ItemStack current = this.zombie.m_6844_(EquipmentSlot.MAINHAND);
            if (current.m_41619_()) {
                return true;
            }
            double newDmg = this.getDamage(stack);
            return newDmg > (curDmg = this.getDamage(current));
        }
        return false;
    }

    private double getDamage(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof SwordItem) {
            SwordItem s = (SwordItem)item;
            return s.m_43299_();
        }
        item = stack.m_41720_();
        if (item instanceof DiggerItem) {
            DiggerItem d = (DiggerItem)item;
            return d.m_41008_();
        }
        return 0.0;
    }

    private void equipItem(ItemStack stack) {
        EquipmentSlot slot = EquipmentSlot.MAINHAND;
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            slot = armor.m_40402_();
        }
        this.zombie.m_8061_(slot, stack.m_41777_());
        this.zombie.m_21409_(slot, 1.0f);
    }
}

