/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class NodeSiegeBreaker
extends BehaviorNode {
    private int breakProgress = 0;
    private BlockPos breakingBlock = null;
    private int stuckTimer = 0;
    private Vec3 lastPos;
    private int giveUpTimer = 0;

    public NodeSiegeBreaker(Zombie zombie) {
        super(zombie);
        this.lastPos = zombie.m_20182_();
    }

    @Override
    public BehaviorStatus tick() {
        BlockHitResult hit;
        if (this.zombie.m_6162_()) {
            return BehaviorStatus.FAILURE;
        }
        if (!this.zombie.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            return BehaviorStatus.FAILURE;
        }
        LivingEntity target = this.zombie.m_5448_();
        if (target == null) {
            this.reset();
            return BehaviorStatus.FAILURE;
        }
        if (this.breakingBlock != null) {
            if (this.giveUpTimer++ > 100) {
                this.reset();
                return BehaviorStatus.FAILURE;
            }
            this.processBreaking();
            return BehaviorStatus.RUNNING;
        }
        double moveDist = this.zombie.m_20182_().m_82557_(this.lastPos);
        this.lastPos = this.zombie.m_20182_();
        if (moveDist > 0.0025) {
            this.stuckTimer = 0;
            return BehaviorStatus.FAILURE;
        }
        ++this.stuckTimer;
        if (this.stuckTimer < 30) {
            return BehaviorStatus.FAILURE;
        }
        BlockPos facePos = new BlockPos.MutableBlockPos(this.zombie.m_20185_(), this.zombie.m_20188_(), this.zombie.m_20189_()).m_121945_(this.zombie.m_6350_());
        if (this.isBreakableObstacle(this.zombie.m_9236_().m_8055_(facePos))) {
            this.startBreaking(facePos);
            return BehaviorStatus.RUNNING;
        }
        if (this.zombie.m_20280_((Entity)target) < 100.0 && (hit = this.zombie.m_9236_().m_45547_(new ClipContext(this.zombie.m_146892_(), target.m_146892_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.zombie))).m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = hit.m_82425_();
            if (this.zombie.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)pos)) < 9.0) {
                BlockState s = this.zombie.m_9236_().m_8055_(pos);
                if (this.isBreakableObstacle(s)) {
                    this.startBreaking(pos);
                    return BehaviorStatus.RUNNING;
                }
                BlockPos floor = this.zombie.m_20183_().m_7495_();
                if (this.isHardObstacle(s) && this.isDiggable(this.zombie.m_9236_().m_8055_(floor))) {
                    this.startBreaking(floor);
                    return BehaviorStatus.RUNNING;
                }
            }
        }
        return BehaviorStatus.FAILURE;
    }

    private void startBreaking(BlockPos pos) {
        this.breakingBlock = pos;
        this.breakProgress = 0;
        this.giveUpTimer = 0;
        this.zombie.m_21573_().m_26573_();
    }

    private void processBreaking() {
        if (this.breakingBlock == null) {
            return;
        }
        this.zombie.m_21563_().m_24946_((double)this.breakingBlock.m_123341_(), (double)this.breakingBlock.m_123342_(), (double)this.breakingBlock.m_123343_());
        ++this.breakProgress;
        if (this.breakProgress % 5 == 0) {
            this.zombie.m_6674_(InteractionHand.MAIN_HAND);
        }
        if (this.breakProgress % 10 == 0) {
            this.zombie.m_9236_().m_46796_(2001, this.breakingBlock, Block.m_49956_((BlockState)this.zombie.m_9236_().m_8055_(this.breakingBlock)));
        }
        if (this.breakProgress > 50) {
            this.zombie.m_9236_().m_46961_(this.breakingBlock, true);
            this.reset();
            this.stuckTimer = 0;
        }
    }

    private boolean isBreakableObstacle(BlockState s) {
        return s.m_60713_(Blocks.f_50154_) || s.m_60713_(Blocks.f_50166_) || s.m_60713_(Blocks.f_50484_) || s.m_60713_(Blocks.f_50058_) || s.m_60713_(Blocks.f_50185_) || s.m_60713_(Blocks.f_50705_) || s.m_60713_(Blocks.f_50132_) || s.m_60713_(Blocks.f_50274_) || s.m_204336_(BlockTags.f_13089_) || s.m_204336_(BlockTags.f_13035_);
    }

    private boolean isHardObstacle(BlockState s) {
        return s.m_60713_(Blocks.f_50652_) || s.m_60713_(Blocks.f_50222_) || s.m_60713_(Blocks.f_50076_) || s.m_60713_(Blocks.f_152550_) || s.m_60713_(Blocks.f_50080_) || s.m_60713_(Blocks.f_50197_);
    }

    private boolean isDiggable(BlockState s) {
        return s.m_60713_(Blocks.f_50493_) || s.m_60713_(Blocks.f_50440_) || s.m_60713_(Blocks.f_49992_) || s.m_60713_(Blocks.f_49994_) || s.m_60713_(Blocks.f_50546_);
    }

    @Override
    public void reset() {
        this.breakingBlock = null;
        this.breakProgress = 0;
        this.giveUpTimer = 0;
    }
}

