/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class NodeSiegeWait
extends BehaviorNode {
    private int hideTimer = 0;
    private Vec3 hidePos = null;
    private Vec3 siegeAnchorPos = null;
    private Vec3 lastTargetPos = null;
    private int holdPositionTimer = 0;
    private int mySlotInCircle = -1;
    private int moveTimeout = 0;

    public NodeSiegeWait(Zombie zombie) {
        super(zombie);
    }

    @Override
    public BehaviorStatus tick() {
        boolean targetMoved;
        boolean isThreat;
        LivingEntity target = this.zombie.m_5448_();
        if (target == null) {
            return BehaviorStatus.FAILURE;
        }
        double yDiff = target.m_20186_() - this.zombie.m_20186_();
        if (yDiff < 2.5) {
            this.resetSiege();
            return BehaviorStatus.FAILURE;
        }
        boolean bl = isThreat = target.m_21205_().m_41720_() instanceof BowItem || target.m_21205_().m_41720_() instanceof CrossbowItem;
        if (isThreat) {
            if (this.hideTimer-- <= 0 || this.hidePos == null) {
                this.hideTimer = 60;
                this.hidePos = this.findCover(target);
            }
            if (this.hidePos != null) {
                this.zombie.m_21573_().m_26519_(this.hidePos.f_82479_, this.hidePos.f_82480_, this.hidePos.f_82481_, 1.3);
                return BehaviorStatus.RUNNING;
            }
        }
        boolean bl2 = targetMoved = this.lastTargetPos == null || target.m_20182_().m_82557_(this.lastTargetPos) > 25.0;
        if (this.siegeAnchorPos == null || targetMoved || this.holdPositionTimer-- <= 0) {
            if (this.mySlotInCircle < 0 || targetMoved) {
                this.mySlotInCircle = this.assignSlotInCircle(target);
            }
            this.siegeAnchorPos = this.getStableCirclePosition(target, this.mySlotInCircle);
            this.lastTargetPos = target.m_20182_();
            this.holdPositionTimer = 100 + this.zombie.m_217043_().m_188503_(60);
            this.moveTimeout = 0;
            this.zombie.m_21573_().m_26519_(this.siegeAnchorPos.f_82479_, this.siegeAnchorPos.f_82480_, this.siegeAnchorPos.f_82481_, 1.4);
        }
        if (this.siegeAnchorPos != null) {
            double distSqr = this.zombie.m_20182_().m_82557_(this.siegeAnchorPos);
            if (distSqr < 2.5) {
                this.zombie.m_21573_().m_26573_();
                this.zombie.m_21563_().m_24960_((Entity)target, 30.0f, 60.0f);
                this.zombie.m_5618_(this.zombie.m_6080_());
                if (this.zombie.f_19797_ % 60 == 0) {
                    this.zombie.m_6674_(InteractionHand.MAIN_HAND);
                    if (this.zombie.m_217043_().m_188501_() < 0.3f) {
                        this.zombie.m_5496_(SoundEvents.f_12598_, 1.0f, 0.5f);
                    }
                }
            } else {
                if (this.zombie.m_21573_().m_26577_() || this.moveTimeout++ > 100) {
                    this.siegeAnchorPos = null;
                    this.moveTimeout = 0;
                    return BehaviorStatus.FAILURE;
                }
                if (this.zombie.f_19797_ % 10 == 0) {
                    this.zombie.m_21573_().m_26519_(this.siegeAnchorPos.f_82479_, this.siegeAnchorPos.f_82480_, this.siegeAnchorPos.f_82481_, 1.4);
                }
            }
        }
        this.zombie.m_20260_(false);
        return BehaviorStatus.RUNNING;
    }

    private void resetSiege() {
        this.siegeAnchorPos = null;
        this.mySlotInCircle = -1;
        this.zombie.m_20260_(false);
        this.moveTimeout = 0;
    }

    private int assignSlotInCircle(LivingEntity target) {
        List siegers = this.zombie.m_9236_().m_45976_(Zombie.class, target.m_20191_().m_82400_(20.0));
        int myIndex = siegers.indexOf(this.zombie);
        return myIndex >= 0 ? myIndex : this.zombie.m_217043_().m_188503_(12);
    }

    private Vec3 getStableCirclePosition(LivingEntity target, int slot) {
        double angleStep = 0.5235987755982988;
        double angle = angleStep * (double)slot;
        double radius = slot % 2 == 0 ? 3.0 : 6.0;
        double x = target.m_20185_() + Math.cos(angle) * radius;
        double z = target.m_20189_() + Math.sin(angle) * radius;
        int y = this.findGroundY((int)x, (int)target.m_20186_(), (int)z);
        return new Vec3(x, (double)y, z);
    }

    private int findGroundY(int x, int startY, int z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, startY + 5, z);
        for (int i = 0; i < 20; ++i) {
            if (this.zombie.m_9236_().m_8055_((BlockPos)pos).m_60804_((BlockGetter)this.zombie.m_9236_(), (BlockPos)pos)) {
                return pos.m_123342_() + 1;
            }
            pos.m_122184_(0, -1, 0);
        }
        return startY;
    }

    private Vec3 findCover(LivingEntity target) {
        Vec3 targetEye = target.m_146892_();
        BlockPos origin = this.zombie.m_20183_();
        for (int x = -8; x <= 8; x += 2) {
            for (int z = -8; z <= 8; z += 2) {
                BlockHitResult hit;
                BlockPos pos = origin.m_7918_(x, 0, z);
                if (!this.zombie.m_9236_().m_8055_(pos).m_60795_() || (hit = this.zombie.m_9236_().m_45547_(new ClipContext(targetEye, Vec3.m_82512_((Vec3i)pos).m_82520_(0.0, 1.5, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.zombie))).m_6662_() != HitResult.Type.BLOCK) continue;
                return Vec3.m_82512_((Vec3i)pos);
            }
        }
        return null;
    }
}

