/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class NodeSleeperAmbush
extends BehaviorNode {
    private boolean isSleeping = false;

    public NodeSleeperAmbush(Zombie zombie) {
        super(zombie);
    }

    @Override
    public BehaviorStatus tick() {
        boolean isDark;
        if (this.zombie.m_5448_() != null || this.zombie.m_6060_()) {
            this.wakeUp(false);
            return BehaviorStatus.FAILURE;
        }
        BlockPos pos = this.zombie.m_20183_();
        if (this.zombie.m_9236_().m_45517_(LightLayer.BLOCK, pos) > 8) {
            this.wakeUp(false);
            return BehaviorStatus.FAILURE;
        }
        BlockState state = this.zombie.m_9236_().m_8055_(pos);
        boolean inBush = state.m_60713_(Blocks.f_50034_) || state.m_60713_(Blocks.f_50359_) || state.m_60713_(Blocks.f_50035_) || state.m_60713_(Blocks.f_50357_);
        boolean bl = isDark = this.zombie.m_9236_().m_46803_(pos) < 5;
        if (inBush || isDark) {
            Player p = this.zombie.m_9236_().m_45930_((Entity)this.zombie, 5.0);
            if (p != null && !p.m_7500_() && !p.m_5833_()) {
                this.wakeUp(true);
                this.zombie.m_6710_((LivingEntity)p);
                return BehaviorStatus.FAILURE;
            }
            if (!this.isSleeping) {
                this.isSleeping = true;
                this.zombie.m_20260_(true);
                this.zombie.m_20225_(true);
                this.zombie.m_21573_().m_26573_();
            }
            this.zombie.m_21563_().m_24946_(this.zombie.m_20185_(), this.zombie.m_20186_() - 1.0, this.zombie.m_20189_());
            return BehaviorStatus.RUNNING;
        }
        this.wakeUp(false);
        return BehaviorStatus.FAILURE;
    }

    private void wakeUp(boolean aggressive) {
        if (this.isSleeping) {
            this.isSleeping = false;
            this.zombie.m_20260_(false);
            this.zombie.m_20225_(false);
            if (aggressive) {
                this.zombie.m_9236_().m_7605_((Entity)this.zombie, (byte)10);
                this.zombie.m_5496_(SoundEvents.f_12601_, 1.2f, 0.5f);
                this.zombie.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 1, false, false));
            }
        }
    }
}

