/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class NodeSmartInteraction
extends BehaviorNode {
    private int interactCooldown = 0;

    public NodeSmartInteraction(Zombie zombie) {
        super(zombie);
    }

    @Override
    public BehaviorStatus tick() {
        if (this.interactCooldown > 0) {
            --this.interactCooldown;
        }
        if (!(this.zombie.m_21573_().m_26571_() && this.interactCooldown == 0 || this.interactCooldown <= 0)) {
            return BehaviorStatus.FAILURE;
        }
        BlockPos pos = new BlockPos.MutableBlockPos(this.zombie.m_20185_(), this.zombie.m_20186_(), this.zombie.m_20189_()).m_121945_(this.zombie.m_6350_());
        BlockState state = this.zombie.m_9236_().m_8055_(pos);
        if (state.m_60734_() instanceof DoorBlock) {
            boolean isOpen = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            if (!isOpen) {
                if (state.m_204336_(BlockTags.f_13095_)) {
                    this.toggleDoor(pos, state, true);
                    return BehaviorStatus.SUCCESS;
                }
                if (this.tryPressButton(pos)) {
                    return BehaviorStatus.SUCCESS;
                }
            } else {
                return BehaviorStatus.SUCCESS;
            }
        }
        if (state.m_60734_() instanceof TrapDoorBlock && !((Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_)).booleanValue() && state.m_204336_(BlockTags.f_13102_)) {
            this.toggleTrapdoor(pos, state);
            return BehaviorStatus.SUCCESS;
        }
        if (state.m_60734_() instanceof FenceGateBlock && !((Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue()) {
            this.toggleGate(pos, state);
            return BehaviorStatus.SUCCESS;
        }
        return BehaviorStatus.FAILURE;
    }

    private boolean tryPressButton(BlockPos doorPos) {
        for (Direction dir : Direction.values()) {
            BlockPos checkPos = doorPos.m_121945_(dir);
            BlockState checkState = this.zombie.m_9236_().m_8055_(checkPos);
            if (!checkState.m_204336_(BlockTags.f_13093_) && !(checkState.m_60734_() instanceof LeverBlock)) continue;
            boolean isPowered = false;
            if (checkState.m_61138_((Property)ButtonBlock.f_51045_)) {
                isPowered = (Boolean)checkState.m_61143_((Property)ButtonBlock.f_51045_);
            }
            if (checkState.m_61138_((Property)LeverBlock.f_54622_)) {
                isPowered = (Boolean)checkState.m_61143_((Property)LeverBlock.f_54622_);
            }
            if (isPowered) continue;
            Block block = checkState.m_60734_();
            if (block instanceof ButtonBlock) {
                ButtonBlock button = (ButtonBlock)block;
                button.m_51116_(checkState, this.zombie.m_9236_(), checkPos);
            } else {
                block = checkState.m_60734_();
                if (block instanceof LeverBlock) {
                    LeverBlock lever = (LeverBlock)block;
                    lever.m_54676_(checkState, this.zombie.m_9236_(), checkPos);
                }
            }
            this.zombie.m_6674_(InteractionHand.MAIN_HAND);
            this.interactCooldown = 20;
            return true;
        }
        return false;
    }

    private void toggleDoor(BlockPos pos, BlockState state, boolean open) {
        this.zombie.m_9236_().m_7731_(pos, (BlockState)state.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(open)), 10);
        this.zombie.m_5496_(SoundEvents.f_12627_, 1.0f, 1.0f);
        this.zombie.m_6674_(InteractionHand.MAIN_HAND);
        this.interactCooldown = 15;
    }

    private void toggleTrapdoor(BlockPos pos, BlockState state) {
        this.zombie.m_9236_().m_7731_(pos, (BlockState)state.m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(true)), 3);
        this.zombie.m_5496_(SoundEvents.f_12629_, 1.0f, 1.0f);
        this.zombie.m_6674_(InteractionHand.MAIN_HAND);
        this.interactCooldown = 10;
    }

    private void toggleGate(BlockPos pos, BlockState state) {
        this.zombie.m_9236_().m_7731_(pos, (BlockState)state.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.valueOf(true)), 3);
        this.zombie.m_5496_(SoundEvents.f_11873_, 1.0f, 1.0f);
        this.zombie.m_6674_(InteractionHand.MAIN_HAND);
        this.interactCooldown = 10;
    }
}

