/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.ZombieHearingSystem;
import com.j2k.deadlybrains.ai.ZombieSquadManager;
import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class NodeStrategicApproach
extends BehaviorNode {
    private final ZombieHearingSystem hearingSystem;
    private int callCooldown = 0;
    private int strafeTimer = 0;
    private boolean strafeLeft = false;

    public NodeStrategicApproach(Zombie zombie, ZombieHearingSystem hearingSystem) {
        super(zombie);
        this.hearingSystem = hearingSystem;
        ZombieSquadManager.register(zombie);
    }

    @Override
    public BehaviorStatus tick() {
        Player p;
        LivingEntity target = this.zombie.m_5448_();
        if (target == null || !target.m_6084_()) {
            return BehaviorStatus.FAILURE;
        }
        if (target instanceof Player && ((p = (Player)target).m_7500_() || p.m_5833_())) {
            this.zombie.m_6710_(null);
            return BehaviorStatus.FAILURE;
        }
        double distSqr = this.zombie.m_20280_((Entity)target);
        if (distSqr < 5.0) {
            this.zombie.m_21573_().m_26573_();
            return BehaviorStatus.FAILURE;
        }
        Vec3 sep = this.calculateSeparation();
        if (sep != null) {
            Vec3 currentMove = this.zombie.m_20184_();
            this.zombie.m_20256_(currentMove.m_82549_(sep.m_82490_(0.2)));
        }
        if (this.zombie.f_20916_ > 0 && distSqr > 64.0) {
            this.performStrafe(target);
            return BehaviorStatus.RUNNING;
        }
        if (this.zombie.m_21573_().m_26571_()) {
            this.zombie.m_21573_().m_5624_((Entity)target, 1.3);
        }
        if ((this.zombie.f_19797_ + this.zombie.m_19879_()) % 10 == 0) {
            if (distSqr > 625.0) {
                this.zombie.m_21573_().m_5624_((Entity)target, 1.4);
            } else {
                Vec3 tacticalPos = ZombieSquadManager.getTacticalPosition(this.zombie, target);
                boolean moveSuccess = false;
                if (tacticalPos != null) {
                    moveSuccess = this.zombie.m_21573_().m_26519_(tacticalPos.f_82479_, tacticalPos.f_82480_, tacticalPos.f_82481_, 1.3);
                }
                if (!moveSuccess) {
                    this.zombie.m_21573_().m_5624_((Entity)target, 1.3);
                }
            }
        }
        if (ZombieSquadManager.isLoneScout(this.zombie) && this.callCooldown-- <= 0) {
            this.zombie.m_5496_(SoundEvents.f_12598_, 3.0f, 0.5f);
            this.hearingSystem.onLoudNoise(this.zombie, target.m_20182_());
            this.callCooldown = 100;
        }
        return BehaviorStatus.RUNNING;
    }

    private void performStrafe(LivingEntity target) {
        if (this.strafeTimer-- <= 0) {
            this.strafeTimer = 15 + this.zombie.m_217043_().m_188503_(10);
            this.strafeLeft = !this.strafeLeft;
        }
        Vec3 forward = target.m_20182_().m_82546_(this.zombie.m_20182_()).m_82541_();
        Vec3 right = new Vec3(-forward.f_82481_, 0.0, forward.f_82479_);
        Vec3 dir = this.strafeLeft ? right : right.m_82490_(-1.0);
        Vec3 move = dir.m_82490_(2.0).m_82549_(forward.m_82490_(0.5));
        this.zombie.m_21573_().m_26519_(this.zombie.m_20185_() + move.f_82479_, this.zombie.m_20186_(), this.zombie.m_20189_() + move.f_82481_, 1.45);
    }

    private Vec3 calculateSeparation() {
        List neighbors = this.zombie.m_9236_().m_45976_(Zombie.class, this.zombie.m_20191_().m_82400_(0.6));
        if (neighbors.size() <= 1) {
            return null;
        }
        Vec3 push = Vec3.f_82478_;
        for (Zombie other : neighbors) {
            if (other == this.zombie) continue;
            Vec3 away = this.zombie.m_20182_().m_82546_(other.m_20182_()).m_82541_();
            push = push.m_82549_(away);
        }
        return push.m_82541_();
    }
}

