/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class NodeTacticalEvasion
extends BehaviorNode {
    private int dodgeTimer = 0;
    private boolean dodgeLeft = false;
    private int crouchTimer = 0;

    public NodeTacticalEvasion(Zombie zombie) {
        super(zombie);
    }

    @Override
    public BehaviorStatus tick() {
        boolean holdingRanged;
        LivingEntity target = this.zombie.m_5448_();
        if (target == null || !target.m_6084_()) {
            this.stopEvasion();
            return BehaviorStatus.FAILURE;
        }
        boolean bl = holdingRanged = this.isRanged(target.m_21205_()) || this.isRanged(target.m_21206_());
        if (holdingRanged && target.m_6117_()) {
            this.zombie.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (this.crouchTimer-- <= 0) {
                this.crouchTimer = 5 + this.zombie.m_217043_().m_188503_(10);
                boolean shouldCrouch = !this.zombie.m_6144_();
                this.zombie.m_20260_(shouldCrouch);
            }
            if (this.dodgeTimer-- <= 0) {
                this.dodgeTimer = 10 + this.zombie.m_217043_().m_188503_(15);
                this.dodgeLeft = this.zombie.m_217043_().m_188499_();
                if (this.zombie.m_20096_() && this.zombie.m_217043_().m_188501_() < 0.3f) {
                    this.zombie.m_21569_().m_24901_();
                }
            }
            Vec3 playerLook = target.m_20154_().m_82541_();
            Vec3 right = new Vec3(-playerLook.f_82481_, 0.0, playerLook.f_82479_);
            Vec3 moveDir = this.dodgeLeft ? right : right.m_82490_(-1.0);
            Vec3 finalMove = moveDir.m_82490_(1.5).m_82549_(playerLook.m_82490_(0.3));
            this.zombie.m_21573_().m_26519_(this.zombie.m_20185_() + finalMove.f_82479_ * 3.0, this.zombie.m_20186_(), this.zombie.m_20189_() + finalMove.f_82481_ * 3.0, 1.35);
            return BehaviorStatus.RUNNING;
        }
        this.stopEvasion();
        return BehaviorStatus.FAILURE;
    }

    private boolean isRanged(ItemStack stack) {
        return stack.m_41720_() instanceof BowItem || stack.m_41720_() instanceof CrossbowItem;
    }

    private void stopEvasion() {
        if (this.zombie.m_6144_()) {
            this.zombie.m_20260_(false);
        }
    }
}

