/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai.nodes;

import com.j2k.deadlybrains.ai.ZombieHearingSystem;
import com.j2k.deadlybrains.ai.behavior.BehaviorNode;
import com.j2k.deadlybrains.ai.behavior.BehaviorStatus;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class NodeTacticalRetreat
extends BehaviorNode {
    private final ZombieHearingSystem hearingSystem;
    private Vec3 retreatPos = null;
    private boolean isRetreating = false;
    private int callForHelpCooldown = 0;
    private int retreatFailures = 0;

    public NodeTacticalRetreat(Zombie zombie, ZombieHearingSystem hearingSystem) {
        super(zombie);
        this.hearingSystem = hearingSystem;
    }

    @Override
    public BehaviorStatus tick() {
        LivingEntity target = this.zombie.m_5448_();
        if (target == null) {
            this.reset();
            return BehaviorStatus.FAILURE;
        }
        float health = this.zombie.m_21223_() / this.zombie.m_21233_();
        if (health > 0.25f) {
            this.reset();
            return BehaviorStatus.FAILURE;
        }
        if (this.retreatFailures >= 3) {
            this.performLastStand();
            return BehaviorStatus.FAILURE;
        }
        List allies = this.zombie.m_9236_().m_45976_(Zombie.class, this.zombie.m_20191_().m_82400_(15.0));
        if (allies.size() >= 3) {
            this.reset();
            return BehaviorStatus.FAILURE;
        }
        if (!this.isRetreating) {
            this.retreatPos = this.findRetreatPosition(target);
            if (this.retreatPos != null) {
                this.isRetreating = true;
                this.zombie.m_21573_().m_26519_(this.retreatPos.f_82479_, this.retreatPos.f_82480_, this.retreatPos.f_82481_, 1.6);
                this.zombie.m_5496_(SoundEvents.f_12608_, 1.0f, 1.2f);
            } else {
                ++this.retreatFailures;
                return BehaviorStatus.FAILURE;
            }
        }
        if (this.isRetreating) {
            if (this.zombie.m_20182_().m_82557_(this.retreatPos) < 4.0) {
                this.zombie.m_20260_(true);
                this.zombie.m_21573_().m_26573_();
                if (this.callForHelpCooldown-- <= 0) {
                    this.callForHelpCooldown = 60;
                    this.hearingSystem.onLoudNoise(this.zombie, target.m_20182_());
                    this.zombie.m_9236_().m_7605_((Entity)this.zombie, (byte)10);
                }
                if (allies.size() >= 2) {
                    this.reset();
                    return BehaviorStatus.SUCCESS;
                }
            }
            if (this.zombie.m_21573_().m_26577_()) {
                ++this.retreatFailures;
                this.isRetreating = false;
            }
            return BehaviorStatus.RUNNING;
        }
        return BehaviorStatus.FAILURE;
    }

    private void performLastStand() {
        this.zombie.m_21153_(this.zombie.m_21233_() * 0.5f);
        this.zombie.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 1));
        this.zombie.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 1));
        this.zombie.m_5496_(SoundEvents.f_12600_, 2.0f, 0.5f);
        this.retreatFailures = 0;
    }

    private Vec3 findRetreatPosition(LivingEntity target) {
        Vec3 away = this.zombie.m_20182_().m_82546_(target.m_20182_()).m_82541_();
        for (int dist = 10; dist <= 20; dist += 5) {
            BlockHitResult hit;
            Vec3 candidate = this.zombie.m_20182_().m_82549_(away.m_82490_((double)dist));
            BlockPos pos = new BlockPos((int)candidate.f_82479_, (int)this.zombie.m_20186_(), (int)candidate.f_82481_);
            if (!this.zombie.m_9236_().m_8055_(pos).m_60795_() || (hit = this.zombie.m_9236_().m_45547_(new ClipContext(target.m_146892_(), candidate, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.zombie))).m_6662_() != HitResult.Type.BLOCK) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public void reset() {
        this.retreatPos = null;
        this.isRetreating = false;
        this.callForHelpCooldown = 0;
        if (this.zombie.m_6144_()) {
            this.zombie.m_20260_(false);
        }
    }
}

