/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.client;

import com.j2k.deadlybrains.DeadlyBrainsConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DeadlyBrainsConfigScreen
extends Screen {
    private final Screen parentScreen;
    private final List<AbstractWidget> scrollableWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> fixedWidgets = new ArrayList<AbstractWidget>();
    private EditBox hordeSizeInput;
    private EditBox dayCooldownInput;
    private EditBox nightCooldownInput;
    private EditBox patrolRadiusInput;
    private double scrollAmount = 0.0;
    private int contentHeight = 0;
    private DeadlyBrainsConfig.Difficulty currentDiff;
    @Nullable
    private Zombie previewZombie;
    private Component performanceWarning;
    private int performanceColor;
    private static final int COLOR_ACCENT = -10496;
    private static final int COLOR_BACKGROUND = -804253680;
    private static final int COLOR_PANEL = -14606047;
    private static final int COLOR_BORDER = -7650029;

    public DeadlyBrainsConfigScreen(Screen parentScreen) {
        super((Component)Component.m_237115_((String)"deadlybrains.config.title"));
        this.parentScreen = parentScreen;
        this.currentDiff = (DeadlyBrainsConfig.Difficulty)((Object)DeadlyBrainsConfig.DIFFICULTY_PRESET.get());
    }

    protected void m_7856_() {
        this.scrollableWidgets.clear();
        this.fixedWidgets.clear();
        this.scrollAmount = 0.0;
        int padding = 10;
        int midW = (this.f_96543_ - padding * 3) / 2;
        int yCursor = 0;
        int widgetH = 20;
        int spacing = 24;
        Button diffBtn = Button.m_253074_((Component)this.getDiffText(), b -> {
            int ordinal = this.currentDiff.ordinal() + 1;
            if (ordinal >= DeadlyBrainsConfig.Difficulty.values().length) {
                ordinal = 0;
            }
            this.currentDiff = DeadlyBrainsConfig.Difficulty.values()[ordinal];
            b.m_93666_(this.getDiffText());
            this.updateInputsFromDifficulty();
        }).m_252987_(0, yCursor, midW - 20, widgetH).m_253136_();
        this.scrollableWidgets.add((AbstractWidget)diffBtn);
        Button burnBtn = Button.m_253074_((Component)this.getBurnText(), b -> {
            DeadlyBrainsConfig.ZOMBIES_BURN.set((Object)((Boolean)DeadlyBrainsConfig.ZOMBIES_BURN.get() == false ? 1 : 0));
            b.m_93666_(this.getBurnText());
        }).m_252987_(0, yCursor += spacing, midW - 20, widgetH).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"deadlybrains.config.zombiesBurn.tooltip"))).m_253136_();
        this.scrollableWidgets.add((AbstractWidget)burnBtn);
        Button daySpawnBtn = Button.m_253074_((Component)this.getDaySpawnText(), b -> {
            DeadlyBrainsConfig.ALLOW_DAY_SPAWN_IF_NOT_BURNING.set((Object)((Boolean)DeadlyBrainsConfig.ALLOW_DAY_SPAWN_IF_NOT_BURNING.get() == false ? 1 : 0));
            b.m_93666_(this.getDaySpawnText());
        }).m_252987_(0, yCursor += spacing, midW - 20, widgetH).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"deadlybrains.config.allowDaySpawn.tooltip"))).m_253136_();
        this.scrollableWidgets.add((AbstractWidget)daySpawnBtn);
        this.hordeSizeInput = this.createInput(yCursor += spacing + 10, midW, "deadlybrains.config.hordeSize", (Integer)DeadlyBrainsConfig.ZOMBIE_SPAWN_CAP.get());
        this.dayCooldownInput = this.createInput(yCursor += spacing + 15, midW, "deadlybrains.config.respawnDay", (Integer)DeadlyBrainsConfig.RESPAWN_COOLDOWN_DAY.get());
        this.nightCooldownInput = this.createInput(yCursor += spacing + 15, midW, "deadlybrains.config.respawnNight", (Integer)DeadlyBrainsConfig.RESPAWN_COOLDOWN_NIGHT.get());
        this.patrolRadiusInput = this.createInput(yCursor += spacing + 15, midW, "deadlybrains.config.patrolRadius", ((Double)DeadlyBrainsConfig.PATROL_RADIUS.get()).intValue());
        this.contentHeight = (yCursor += spacing + 15) + 20;
        int btnY = this.f_96544_ - 30;
        int btnW = 100;
        Button saveBtn = Button.m_253074_((Component)Component.m_237115_((String)"deadlybrains.config.save"), b -> {
            this.saveConfig();
            this.m_7379_();
        }).m_252987_(this.f_96543_ / 2 - btnW - 5, btnY, btnW, 20).m_253136_();
        Button cancelBtn = Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), b -> this.m_7379_()).m_252987_(this.f_96543_ / 2 + 5, btnY, btnW, 20).m_253136_();
        this.fixedWidgets.add((AbstractWidget)saveBtn);
        this.fixedWidgets.add((AbstractWidget)cancelBtn);
        this.scrollableWidgets.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.fixedWidgets.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            this.previewZombie = new Zombie(EntityType.f_20501_, (Level)this.f_96541_.f_91073_);
        }
    }

    private void updateInputsFromDifficulty() {
        this.hordeSizeInput.m_94144_(String.valueOf(this.currentDiff.cap));
        this.dayCooldownInput.m_94144_(String.valueOf(this.currentDiff.cooldown));
        this.nightCooldownInput.m_94144_(String.valueOf(Math.max(5, this.currentDiff.cooldown / 2)));
    }

    private EditBox createInput(int relativeY, int width, String key, int val) {
        EditBox box = new EditBox(this.f_96547_, 10, relativeY, width - 20, 18, (Component)Component.m_237115_((String)key));
        box.m_94144_(String.valueOf(val));
        box.m_94153_(s -> s.matches("\\d*"));
        box.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(key + ".tooltip"))));
        this.scrollableWidgets.add((AbstractWidget)box);
        return box;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -804253680);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, -10496);
        int padding = 10;
        int midW = (this.f_96543_ - padding * 3) / 2;
        int panelH = this.f_96544_ - 70;
        int panelY = 30;
        int leftX = padding;
        int rightX = padding * 2 + midW;
        this.drawPanelBg(graphics, leftX, panelY, midW, panelH, "deadlybrains.config.category.basic");
        double scale = this.f_96541_.m_91268_().m_85449_();
        int scissorY = this.f_96544_ - (panelY + panelH);
        RenderSystem.enableScissor((int)((int)((double)leftX * scale)), (int)((int)((double)(scissorY + 1) * scale)), (int)((int)((double)midW * scale)), (int)((int)((double)(panelH - 21) * scale)));
        int baseWidgetY = panelY + 25;
        int currentRelY = 0;
        int spacing = 24;
        this.updateWidgetPos(this.scrollableWidgets.get(0), leftX + 10, baseWidgetY, currentRelY);
        this.updateWidgetPos(this.scrollableWidgets.get(1), leftX + 10, baseWidgetY, currentRelY += spacing);
        this.updateWidgetPos(this.scrollableWidgets.get(2), leftX + 10, baseWidgetY, currentRelY += spacing);
        this.drawScrollLabel(graphics, this.hordeSizeInput, "deadlybrains.config.hordeSize", leftX + 10, baseWidgetY, currentRelY += spacing + 10);
        this.updateWidgetPos((AbstractWidget)this.hordeSizeInput, leftX + 10, baseWidgetY, currentRelY);
        this.drawScrollLabel(graphics, this.dayCooldownInput, "deadlybrains.config.respawnDay", leftX + 10, baseWidgetY, currentRelY += spacing + 15);
        this.updateWidgetPos((AbstractWidget)this.dayCooldownInput, leftX + 10, baseWidgetY, currentRelY);
        this.drawScrollLabel(graphics, this.nightCooldownInput, "deadlybrains.config.respawnNight", leftX + 10, baseWidgetY, currentRelY += spacing + 15);
        this.updateWidgetPos((AbstractWidget)this.nightCooldownInput, leftX + 10, baseWidgetY, currentRelY);
        this.drawScrollLabel(graphics, this.patrolRadiusInput, "deadlybrains.config.patrolRadius", leftX + 10, baseWidgetY, currentRelY += spacing + 15);
        this.updateWidgetPos((AbstractWidget)this.patrolRadiusInput, leftX + 10, baseWidgetY, currentRelY);
        RenderSystem.disableScissor();
        this.drawPanelBg(graphics, rightX, panelY, midW, panelH, "deadlybrains.config.preview");
        int zombieCX = rightX + midW / 2;
        int zombieCY = panelY + panelH / 2 + 20;
        if (this.previewZombie != null) {
            int zScale = Math.min(midW / 3, panelH / 3);
            InventoryScreen.m_274545_((GuiGraphics)graphics, (int)zombieCX, (int)zombieCY, (int)zScale, (float)((float)zombieCX - (float)mouseX), (float)((float)(zombieCY - 50) - (float)mouseY), (LivingEntity)this.previewZombie);
        }
        this.updatePerformanceWarning();
        int infoY = panelY + panelH - 50;
        if (this.performanceWarning != null) {
            graphics.m_280653_(this.f_96547_, this.performanceWarning, zombieCX, infoY, this.performanceColor);
        }
        MutableComponent diffName = Component.m_237115_((String)("deadlybrains.config.difficulty." + this.currentDiff.name()));
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"deadlybrains.config.difficulty").m_130946_(": ").m_7220_((Component)diffName), zombieCX, infoY + 15, 0x888888);
        for (AbstractWidget w : this.fixedWidgets) {
            w.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
        RenderSystem.enableScissor((int)((int)((double)leftX * scale)), (int)((int)((double)(scissorY + 1) * scale)), (int)((int)((double)midW * scale)), (int)((int)((double)(panelH - 21) * scale)));
        for (AbstractWidget w : this.scrollableWidgets) {
            w.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
        RenderSystem.disableScissor();
        if (this.contentHeight > panelH - 30) {
            int barH = (int)((float)(panelH - 30) * ((float)(panelH - 30) / (float)this.contentHeight));
            int barY = panelY + 25 + (int)((double)(panelH - 30 - barH) * (this.scrollAmount / (double)(this.contentHeight - (panelH - 30))));
            graphics.m_280509_(leftX + midW - 6, panelY + 25, leftX + midW - 2, panelY + panelH - 5, -16777216);
            graphics.m_280509_(leftX + midW - 5, barY, leftX + midW - 3, barY + barH, -10496);
        }
    }

    private void updateWidgetPos(AbstractWidget w, int x, int baseY, int relY) {
        w.m_252865_(x);
        w.m_253211_(baseY + relY - (int)this.scrollAmount);
    }

    private void drawScrollLabel(GuiGraphics g, EditBox box, String key, int x, int baseY, int relY) {
        int finalY = baseY + relY - (int)this.scrollAmount - 10;
        if (finalY > 30 && finalY < this.f_96544_ - 40) {
            g.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)key), x, finalY, -10496, false);
        }
    }

    private void drawPanelBg(GuiGraphics g, int x, int y, int w, int h, String title) {
        g.m_280509_(x, y, x + w, y + h, -14606047);
        g.m_280637_(x, y, w, h, -7650029);
        g.m_280509_(x, y, x + w, y + 20, -14013910);
        g.m_280509_(x, y + 19, x + w, y + 20, -10496);
        g.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)title), x + 8, y + 6, -10496);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int panelH = this.f_96544_ - 70;
        int maxScroll = Math.max(0, this.contentHeight - (panelH - 30));
        if (maxScroll > 0) {
            this.scrollAmount = Mth.m_14008_((double)(this.scrollAmount - delta * 20.0), (double)0.0, (double)maxScroll);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void saveConfig() {
        try {
            DeadlyBrainsConfig.DIFFICULTY_PRESET.set((Object)this.currentDiff);
            DeadlyBrainsConfig.ZOMBIE_SPAWN_CAP.set((Object)this.parseInt(this.hordeSizeInput));
            DeadlyBrainsConfig.RESPAWN_COOLDOWN_DAY.set((Object)this.parseInt(this.dayCooldownInput));
            DeadlyBrainsConfig.RESPAWN_COOLDOWN_NIGHT.set((Object)this.parseInt(this.nightCooldownInput));
            DeadlyBrainsConfig.PATROL_RADIUS.set((Object)this.parseInt(this.patrolRadiusInput));
            DeadlyBrainsConfig.COMMON_CONFIG.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int parseInt(EditBox box) {
        try {
            return Integer.parseInt(box.m_94155_());
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void updatePerformanceWarning() {
        int size = this.parseInt(this.hordeSizeInput);
        if (size >= 100) {
            this.performanceWarning = Component.m_237115_((String)"deadlybrains.config.warn.lag");
            this.performanceColor = -43691;
        } else {
            this.performanceWarning = Component.m_237115_((String)"deadlybrains.config.warn.stable");
            this.performanceColor = -11141291;
        }
    }

    private Component getDiffText() {
        MutableComponent diffName = Component.m_237115_((String)("deadlybrains.config.difficulty." + this.currentDiff.name()));
        return Component.m_237115_((String)"deadlybrains.config.difficulty").m_130946_(": ").m_7220_((Component)diffName);
    }

    private Component getBurnText() {
        String state = (Boolean)DeadlyBrainsConfig.ZOMBIES_BURN.get() != false ? "ON" : "OFF";
        return Component.m_237115_((String)"deadlybrains.config.zombiesBurn").m_130946_(": " + state);
    }

    private Component getDaySpawnText() {
        String state = (Boolean)DeadlyBrainsConfig.ALLOW_DAY_SPAWN_IF_NOT_BURNING.get() != false ? "ON" : "OFF";
        return Component.m_237115_((String)"deadlybrains.config.allowDaySpawn").m_130946_(": " + state);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    public boolean m_7043_() {
        return true;
    }
}

