/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.event;

import com.j2k.deadlybrains.DeadlyBrainsConfig;
import com.j2k.deadlybrains.ai.SmartZombieBrainGoal;
import com.j2k.deadlybrains.ai.ZombieDamageHandler;
import com.j2k.deadlybrains.ai.ZombieHearingSystem;
import com.j2k.deadlybrains.ai.ZombieSoundEventHandler;
import com.j2k.deadlybrains.ai.ZombieSpawnHandler;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ZombieAIEventHandler {
    private final ZombieHearingSystem hearingSystem = new ZombieHearingSystem();
    private final ZombieSoundEventHandler soundEvents;
    private final ZombieSpawnHandler spawnHandler = new ZombieSpawnHandler();
    private final ZombieDamageHandler damageHandler = new ZombieDamageHandler();

    public ZombieAIEventHandler() {
        this.soundEvents = new ZombieSoundEventHandler(this.hearingSystem);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this.soundEvents);
        MinecraftForge.EVENT_BUS.register((Object)this.spawnHandler);
        MinecraftForge.EVENT_BUS.register((Object)this.damageHandler);
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            zombie.m_34336_(true);
            zombie.m_21441_(BlockPathTypes.WATER, 16.0f);
            Set goals = zombie.f_21345_.m_148105_();
            ArrayList<Goal> toRemove = new ArrayList<Goal>();
            for (WrappedGoal wrapped : goals) {
                String name = wrapped.m_26015_().getClass().getSimpleName();
                if (!name.contains("Wander") && !name.contains("Attack") && !name.contains("Flee") && !name.contains("RestrictSun")) continue;
                toRemove.add(wrapped.m_26015_());
            }
            toRemove.forEach(arg_0 -> ((GoalSelector)zombie.f_21345_).m_25363_(arg_0));
            zombie.f_21345_.m_25352_(0, (Goal)new SmartZombieBrainGoal(zombie, this.hearingSystem));
            zombie.f_21345_.m_25352_(1, (Goal)new BreakDoorGoal((Mob)zombie, e -> true));
            zombie.m_6710_(null);
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Zombie) {
            Zombie zombie = (Zombie)livingEntity;
            if (!((Boolean)DeadlyBrainsConfig.ZOMBIES_BURN.get()).booleanValue() && zombie.m_6060_() && zombie.m_9236_().m_46461_()) {
                zombie.m_20095_();
            }
        }
    }
}

