/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import java.util.List;
import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class AethersCallArrow
extends AbstractArrow {
    private static final int MAX_LIFETIME = 80;
    private int lifetime = 0;

    public AethersCallArrow(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public AethersCallArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.AETHERS_CALL_ARROW.get(), shooter, level, bowStack, arrowStack);
        this.setBaseDamage(6.0);
    }

    public void tick() {
        super.tick();
        ++this.lifetime;
        if (this.lifetime > 80) {
            this.discard();
            return;
        }
        if (this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getX(), this.getY() + 0.1, this.getZ(), 0.0, 0.02, 0.0);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        this.triggerAetherBurst();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.triggerAetherBurst();
    }

    private void triggerAetherBurst() {
        LivingEntity livingEntity;
        if (this.level().isClientSide) {
            return;
        }
        Level level = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        double radius = 4.0;
        level.playSound(null, x, y, z, SoundEvents.AMETHYST_CLUSTER_BREAK, SoundSource.PLAYERS, 1.0f, 1.5f);
        List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius));
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            livingEntity = living;
        } else {
            livingEntity = null;
        }
        LivingEntity owner = livingEntity;
        for (LivingEntity target : entities) {
            if (owner != null && target == owner) {
                target.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 100, 0, false, true));
                continue;
            }
            target.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 40, 0, false, true));
        }
        for (int i = 0; i < 20; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 1.5;
            double dy = this.random.nextDouble() * 1.5;
            double dz = (this.random.nextDouble() - 0.5) * 1.5;
            level.addParticle((ParticleOptions)ParticleTypes.END_ROD, x + dx, y + dy, z + dz, 0.0, 0.02, 0.0);
        }
        this.discard();
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return null;
    }
}

