/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EffectRegistry;
import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class CursedFlameArrow
extends AbstractArrow {
    private float powerMultiplier = 1.0f;
    private int particleTimer = 0;
    private static final int MAX_PARTICLE_DURATION = 100;

    public void setPowerMultiplier(float power) {
        this.powerMultiplier = power;
    }

    public CursedFlameArrow(EntityType<? extends CursedFlameArrow> entityType, Level level) {
        super(entityType, level);
    }

    public CursedFlameArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.CURSED_FLAME_ARROW.get(), shooter, level, bowStack, arrowStack);
    }

    public void tick() {
        super.tick();
        if (this.inGround) {
            ++this.particleTimer;
        }
        if (this.particleTimer < 100 && this.level().isClientSide()) {
            Vec3 motion = this.getDeltaMovement();
            for (int i = 0; i < 5; ++i) {
                double xOffset = (this.random.nextDouble() - 0.5) * 0.3;
                double yOffset = (this.random.nextDouble() - 0.5) * 0.3;
                double zOffset = (this.random.nextDouble() - 0.5) * 0.3;
                this.level().addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.getX() + motion.x * (double)i * 0.1, this.getY() + motion.y * (double)i * 0.1, this.getZ() + motion.z * (double)i * 0.1, xOffset, yOffset, zOffset);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide() && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity hit = (LivingEntity)entity;
            hit.setRemainingFireTicks(200);
            float fireDamage = 4.0f;
            Entity entity2 = this.getOwner();
            if (entity2 instanceof LivingEntity) {
                AttributeInstance inst;
                ResourceKey rangedKey;
                LivingEntity shooter = (LivingEntity)entity2;
                Registry attrRegistry = this.level().registryAccess().registryOrThrow(Registries.ATTRIBUTE);
                Holder.Reference rangedHolder = attrRegistry.getHolder(rangedKey = ResourceKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ranged_weapon", (String)"damage"))).orElse(null);
                if (rangedHolder != null && (inst = shooter.getAttribute((Holder)rangedHolder)) != null) {
                    fireDamage = (float)inst.getValue() / 1.5f;
                }
            }
            hit.hurt(hit.damageSources().onFire(), fireDamage * this.powerMultiplier);
            hit.removeEffect(MobEffects.REGENERATION);
            hit.removeEffect(MobEffects.HEAL);
            Registry mobEffectRegistry = this.level().registryAccess().registryOrThrow(Registries.MOB_EFFECT);
            Holder.Reference cursedFlameHolder = mobEffectRegistry.getHolderOrThrow(EffectRegistry.CURSED_FLAME.getKey());
            hit.addEffect(new MobEffectInstance((Holder)cursedFlameHolder, 160, 0, false, true));
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                sl.sendParticles((ParticleOptions)ParticleTypes.SOUL, hit.getX(), hit.getY(0.5), hit.getZ(), 30, 1.0, 0.5, 1.0, 0.1);
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        Level level;
        super.onHitBlock(result);
        if (!this.level().isClientSide() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 position = result.getLocation();
            BlockPos hitPos = new BlockPos((int)position.x, (int)position.y, (int)position.z);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, position.x, position.y, position.z, 30, 0.5, 0.5, 0.5, 0.01);
            serverLevel.playSound(null, position.x, position.y, position.z, (Holder)SoundEvents.SOUL_ESCAPE, this.getSoundSource(), 1.0f, 1.0f);
            this.particleTimer = 100;
        }
    }

    private void createCursedSoulFireParticles(Vec3 position) {
        for (int i = 0; i < 30; ++i) {
            double xOffset = (this.random.nextDouble() - 0.5) * 2.0;
            double yOffset = this.random.nextDouble() * 0.5;
            double zOffset = (this.random.nextDouble() - 0.5) * 2.0;
            this.level().addParticle((ParticleOptions)ParticleTypes.SOUL, position.x + xOffset, position.y + yOffset, position.z + zOffset, 0.0, 0.1, 0.0);
        }
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

