/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.item.TorchbearerBow;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class LightOrbEntity
extends Entity {
    private static final double FOLLOW_DISTANCE = 1.5;
    private BlockPos lastLightPos = null;

    public LightOrbEntity(EntityType<? extends LightOrbEntity> type, Level world) {
        super(type, world);
        this.noPhysics = true;
        this.setInvisible(true);
        this.setNoGravity(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        Player nearestPlayer = this.level().getNearestPlayer((Entity)this, 5.0);
        if (nearestPlayer != null && this.isPlayerHoldingTorchBow(nearestPlayer)) {
            double dx = nearestPlayer.getX() - this.getX();
            double dy = nearestPlayer.getY() + 1.5 - this.getY();
            double dz = nearestPlayer.getZ() - this.getZ();
            this.move(MoverType.SELF, this.getDeltaMovement().add(dx * 0.2, dy * 0.2, dz * 0.2));
            BlockPos currentPos = this.blockPosition();
            if (this.lastLightPos == null || !this.lastLightPos.equals((Object)currentPos)) {
                BlockState currentState;
                if (this.lastLightPos != null && this.level().getBlockState(this.lastLightPos).is(Blocks.LIGHT)) {
                    this.level().setBlockAndUpdate(this.lastLightPos, Blocks.AIR.defaultBlockState());
                }
                if ((currentState = this.level().getBlockState(currentPos)).isAir()) {
                    this.level().setBlockAndUpdate(currentPos, Blocks.LIGHT.defaultBlockState());
                    this.lastLightPos = currentPos;
                }
            }
        } else {
            if (this.lastLightPos != null && this.level().getBlockState(this.lastLightPos).is(Blocks.LIGHT)) {
                this.level().setBlockAndUpdate(this.lastLightPos, Blocks.AIR.defaultBlockState());
            }
            this.discard();
        }
    }

    private boolean isPlayerHoldingTorchBow(Player player) {
        return player.getMainHandItem().getItem() instanceof TorchbearerBow || player.getOffhandItem().getItem() instanceof TorchbearerBow;
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
    }
}

