/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpectralArrow
extends AbstractArrow {
    private int remainingObstacles;
    private int lifespan = 140;

    public SpectralArrow(EntityType<? extends SpectralArrow> entityType, Level level) {
        super(entityType, level);
    }

    public SpectralArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.SPECTRAL_ARROW.get(), shooter, level, bowStack, arrowStack);
        this.setBaseDamage(7.0);
        this.remainingObstacles = 1;
    }

    public void tick() {
        Vec3 nextPosition;
        super.tick();
        if (--this.lifespan <= 0) {
            this.discard();
            return;
        }
        Vec3 currentPosition = this.position();
        EntityHitResult entityHitResult = this.findHitEntity(currentPosition, nextPosition = currentPosition.add(this.getDeltaMovement()));
        if (entityHitResult != null) {
            this.onHitEntity(entityHitResult);
            return;
        }
        BlockHitResult blockHitResult = this.level().clip(new ClipContext(currentPosition, nextPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (blockHitResult.getType() == HitResult.Type.BLOCK) {
            this.onHitBlock(blockHitResult);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        if (!this.level().isClientSide()) {
            if (this.remainingObstacles > 0) {
                --this.remainingObstacles;
                Vec3 movement = this.getDeltaMovement();
                Vec3 hitPos = result.getLocation();
                this.setPos(hitPos.x + movement.x * 0.5, hitPos.y + movement.y * 0.5, hitPos.z + movement.z * 0.5);
                this.setDeltaMovement(movement);
            } else {
                this.setDeltaMovement(Vec3.ZERO);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        if (!this.level().isClientSide() && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (super.canHitEntity(result.getEntity())) {
                target.hurt(this.damageSources().arrow((AbstractArrow)this, this.getOwner()), (float)this.getBaseDamage());
                this.discard();
            }
        }
    }

    public EntityHitResult findHitEntity(Vec3 start, Vec3 end) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)start, (Vec3)end, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), entity -> super.canHitEntity(entity));
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

