/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import java.util.List;
import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class WindProjectile
extends AbstractArrow {
    private static final float BASE_DAMAGE = 3.0f;
    private static final double GUST_RADIUS = 4.0;
    private static final double KNOCKBACK_STRENGTH = 1.1;
    private static final int SHOOTER_SPEED_DURATION = 60;
    private static final int SHOOTER_SLOW_FALL_DURATION = 60;

    public WindProjectile(EntityType<? extends WindProjectile> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(3.0);
    }

    public WindProjectile(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.WIND_PROJECTILE.get(), shooter, level, bowStack, arrowStack);
        this.setBaseDamage(3.0);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide()) {
            Entity hit = result.getEntity();
            if (hit instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)hit;
                target.hurt(this.damageSources().magic(), (float)this.getBaseDamage());
            }
            this.spawnGust(this.getX(), this.getY(), this.getZ());
        }
        this.discard();
    }

    private void spawnGust(double x, double y, double z) {
        LivingEntity livingOwner;
        double distSqr;
        Level level = this.level();
        if (level.isClientSide()) {
            return;
        }
        AABB area = new AABB(x - 4.0, y - 4.0, z - 4.0, x + 4.0, y + 4.0, z + 4.0);
        List entities = level.getEntities((Entity)this, area, e -> e instanceof LivingEntity);
        Entity owner = this.getOwner();
        for (Entity entity : entities) {
            Vec3 dir;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            if (owner != null && entity.getUUID().equals(owner.getUUID()) || !((dir = new Vec3(entity.getX() - x, 0.0, entity.getZ() - z)).lengthSqr() > 1.0E-4)) continue;
            dir = dir.normalize().scale(1.1);
            entity.push(dir.x, 0.25, dir.z);
            entity.hurt(this.damageSources().magic(), 1.5f);
        }
        if (owner instanceof LivingEntity && (distSqr = (livingOwner = (LivingEntity)owner).position().distanceToSqr(x, y, z)) <= 16.0) {
            livingOwner.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 60, 1));
            livingOwner.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 60, 0));
        }
        for (int i = 0; i < 30; ++i) {
            double dx = x + (level.random.nextDouble() - 0.5) * 6.0;
            double dy = y + level.random.nextDouble() * 1.5;
            double dz = z + (level.random.nextDouble() - 0.5) * 6.0;
            level.addParticle((ParticleOptions)ParticleTypes.CLOUD, dx, dy, dz, 0.0, 0.05, 0.0);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, this.getX(), this.getY(), this.getZ(), 0.0, 0.05, 0.0);
        }
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

