/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.function.Predicate;
import net.bandit.many_bows.entity.AethersCallArrow;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AethersCall
extends BowItem {
    public AethersCall(Item.Properties properties) {
        super(properties);
    }

    /*
     * Unable to fully structure code
     */
    public void releaseUsing(ItemStack bowStack, Level level, LivingEntity entity, int chargeTime) {
        block7: {
            if (!(entity instanceof Player)) {
                return;
            }
            player = (Player)entity;
            arrowStack = player.getProjectile(bowStack);
            if (arrowStack.isEmpty() && !player.getAbilities().instabuild) {
                return;
            }
            charge = this.getUseDuration(bowStack, entity) - chargeTime;
            power = AethersCall.getPowerForTime(charge);
            if (power < 0.1f) {
                return;
            }
            projectiles = AethersCall.draw((ItemStack)bowStack, (ItemStack)arrowStack, (LivingEntity)player);
            arrowConsumed = false;
            if (projectiles.isEmpty() || !(level instanceof ServerLevel)) break block7;
            serverLevel = (ServerLevel)level;
            for (ItemStack projectileStack : projectiles) {
                var16_16 = projectileStack.getItem();
                if (!(var16_16 instanceof ArrowItem)) ** GOTO lbl-1000
                arrowItem = (ArrowItem)var16_16;
                if (projectileStack.is(Items.SPECTRAL_ARROW) || projectileStack.is(Items.TIPPED_ARROW)) {
                    arrow = arrowItem.createArrow((Level)serverLevel, projectileStack, (LivingEntity)player, bowStack);
                } else lbl-1000:
                // 2 sources

                {
                    arrow = new AethersCallArrow((Level)serverLevel, (LivingEntity)player, bowStack, projectileStack);
                }
                this.applyPowerEnchantment(arrow, bowStack, level);
                this.applyKnockbackEnchantment(arrow, bowStack, (LivingEntity)player, level);
                this.applyFlameEnchantment(arrow, bowStack, level);
                arrow.pickup = this.hasInfinityEnchantment(bowStack, level) != false || player.getAbilities().instabuild != false ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, power * 2.5f, 1.0f);
                serverLevel.addFreshEntity((Entity)arrow);
                if (this.hasInfinityEnchantment(bowStack, level) || player.getAbilities().instabuild || arrowConsumed) continue;
                projectileStack.shrink(1);
                arrowConsumed = true;
            }
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.0f, 1.4f + power * 0.2f);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            bowStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
    }

    private void applyFlameEnchantment(AbstractArrow arrow, ItemStack bow, Level level) {
        Holder<Enchantment> flame = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.FLAME);
        int flameLevel = EnchantmentHelper.getItemEnchantmentLevel(flame, (ItemStack)bow);
        if (flameLevel > 0) {
            arrow.igniteForSeconds(5.0f);
        }
    }

    private void applyKnockbackEnchantment(AbstractArrow arrow, ItemStack bow, LivingEntity shooter, Level level) {
        Holder<Enchantment> punch = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.PUNCH);
        int punchLevel = EnchantmentHelper.getItemEnchantmentLevel(punch, (ItemStack)bow);
        if (punchLevel > 0) {
            double resistance = Math.max(0.0, 1.0 - shooter.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 knockbackVec = arrow.getDeltaMovement().normalize().scale((double)punchLevel * 0.6 * resistance);
            arrow.push(knockbackVec.x, 0.1, knockbackVec.z);
        }
    }

    private void applyPowerEnchantment(AbstractArrow arrow, ItemStack bow, Level level) {
        Holder<Enchantment> power = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.POWER);
        int powerLevel = EnchantmentHelper.getItemEnchantmentLevel(power, (ItemStack)bow);
        if (powerLevel > 0) {
            double extraDamage = 0.5 * (double)powerLevel + 1.0;
            arrow.setBaseDamage(arrow.getBaseDamage() + extraDamage);
        }
    }

    private boolean hasInfinityEnchantment(ItemStack bow, Level level) {
        Holder<Enchantment> infinity = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.INFINITY);
        return EnchantmentHelper.getItemEnchantmentLevel(infinity, (ItemStack)bow) > 0;
    }

    private Holder<Enchantment> getEnchantmentHolder(Level level, ResourceKey<Enchantment> enchantmentKey) {
        return level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(enchantmentKey);
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        projectile.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot() + angle, 0.0f, velocity, inaccuracy);
    }

    public static float getPowerForTime(int charge) {
        float f = (float)charge / 16.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 16;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean hasArrows;
        ItemStack bowStack = player.getItemInHand(hand);
        boolean bl = hasArrows = !player.getProjectile(bowStack).isEmpty();
        if (!player.hasInfiniteMaterials() && !hasArrows) {
            return InteractionResultHolder.fail((Object)bowStack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)bowStack);
    }

    public int getDefaultProjectileRange() {
        return 64;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is((Item)ItemRegistry.POWER_CRYSTAL.get());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.aether_bow.tooltip.extended").withStyle(ChatFormatting.GRAY));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.aether_bow.tooltip").withStyle(ChatFormatting.AQUA));
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.hold_shift").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }
}

