/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.joml.Vector3f;

public class DragonsBreathArrow
extends AbstractArrow {
    private static final int PARTICLE_LIFESPAN = 40;
    private static final int MAX_LIFETIME = 100;
    private int particleTicksRemaining = 40;
    private int lifetime = 0;

    public DragonsBreathArrow(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public DragonsBreathArrow(Level level, LivingEntity shooter) {
        super((EntityType)EntityRegistry.DRAGONS_BREATH_ARROW.get(), shooter, level);
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity2 = result.m_82443_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity2;
            Level level = target.m_9236_();
            level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11892_, SoundSource.PLAYERS, 1.0f, 1.0f);
            level.m_6249_((Entity)this, target.m_20191_().m_82400_(2.0), e -> e instanceof LivingEntity).forEach(entity -> {
                LivingEntity livingEntity;
                if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity) != target) {
                    livingEntity.m_6469_(target.m_269291_().m_269425_(), 4.0f);
                }
            });
            AreaEffectCloud areaEffectCloud = new AreaEffectCloud(level, target.m_20185_(), target.m_20186_(), target.m_20189_());
            areaEffectCloud.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
            areaEffectCloud.m_19712_(3.0f);
            areaEffectCloud.m_19734_(100);
            areaEffectCloud.m_19738_(-0.05f);
            areaEffectCloud.m_19740_(10);
            areaEffectCloud.m_19716_(new MobEffectInstance(MobEffects.f_19602_, 40, 1));
            level.m_7967_((Entity)areaEffectCloud);
            this.createImpactParticles(target.m_20185_(), target.m_20186_(), target.m_20189_());
        }
        this.m_146870_();
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifetime;
        if (this.lifetime > 100) {
            this.m_146870_();
            return;
        }
        if (this.m_9236_().m_5776_() && this.particleTicksRemaining > 0) {
            this.createTrailParticles();
            --this.particleTicksRemaining;
        }
    }

    private void createImpactParticles(double x, double y, double z) {
        for (int i = 0; i < 20; ++i) {
            double xOffset = (this.f_19796_.m_188500_() - 0.5) * 1.5;
            double yOffset = this.f_19796_.m_188500_() * 1.5;
            double zOffset = (this.f_19796_.m_188500_() - 0.5) * 1.5;
            this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.0f), 1.0f), x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
        }
    }

    private void createTrailParticles() {
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, -0.05, 0.0);
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

