/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import java.util.List;
import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FlameArrow
extends AbstractArrow {
    private boolean hasHit = false;
    private int hitTimer = 0;
    private final int maxHitDuration = 40;

    public FlameArrow(EntityType<? extends FlameArrow> entityType, Level level) {
        super(entityType, level);
    }

    public FlameArrow(Level level, LivingEntity shooter) {
        super((EntityType)EntityRegistry.FLAME_ARROW.get(), shooter, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasHit) {
            ++this.hitTimer;
            if (this.hitTimer >= 40) {
                this.m_146870_();
                return;
            }
        }
        if (this.m_9236_().m_5776_()) {
            double speedFactor = 0.1;
            Vec3 motion = this.m_20184_();
            for (int i = 0; i < 5; ++i) {
                double xOffset = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double yOffset = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double zOffset = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + motion.f_82479_ * (double)i * speedFactor, this.m_20186_() + motion.f_82480_ * (double)i * speedFactor, this.m_20189_() + motion.f_82481_ * (double)i * speedFactor, xOffset, yOffset, zOffset);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_9236_().m_5776_()) {
            Entity entity = result.m_82443_();
            if (entity instanceof LivingEntity) {
                LivingEntity hitEntity = (LivingEntity)entity;
                hitEntity.m_20254_(5);
                hitEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 1));
                this.createFireExplosion(result.m_82450_(), hitEntity);
            }
            this.hasHit = true;
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_9236_().m_5776_()) {
            this.createFireExplosion(result.m_82450_(), null);
            this.hasHit = true;
        }
    }

    private void createFireExplosion(Vec3 position, @Nullable LivingEntity entityHit) {
        double zOffset;
        double yOffset;
        int i;
        int radius = 5;
        List entities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_((double)radius));
        for (LivingEntity entity : entities) {
            if (entity == this.m_19749_() || entity == entityHit) continue;
            entity.m_20254_(5);
        }
        for (i = 0; i < 50; ++i) {
            double xOffset = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            yOffset = this.f_19796_.m_188500_();
            zOffset = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, position.f_82479_ + xOffset, position.f_82480_ + yOffset, position.f_82481_ + zOffset, 0.0, 0.1, 0.0);
        }
        for (i = 0; i < 30; ++i) {
            double xOffset = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            yOffset = this.f_19796_.m_188500_() * 0.5;
            zOffset = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, position.f_82479_ + xOffset, position.f_82480_ + yOffset, position.f_82481_ + zOffset, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, position.f_82479_ + xOffset, position.f_82480_ + yOffset, position.f_82481_ + zOffset, 0.0, 0.0, 0.0);
        }
        this.m_9236_().m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, SoundEvents.f_11913_, this.m_5720_(), 1.0f, 1.2f);
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

