/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.bandit.many_bows.util.AncientSageDamageSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;

public class RadiantArrow
extends AbstractArrow {
    private boolean hasExploded = false;

    public RadiantArrow(EntityType<? extends RadiantArrow> entityType, Level level) {
        super(entityType, level);
    }

    public RadiantArrow(Level level, LivingEntity shooter) {
        super((EntityType)EntityRegistry.RADIANT_ARROW.get(), shooter, level);
        this.m_36781_(9.0);
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.hasExploded && result.m_6662_() == HitResult.Type.BLOCK) {
            this.hasExploded = true;
            this.createRadiantExplosion(this.m_9236_(), this);
            this.m_146870_();
        }
    }

    private void createRadiantExplosion(Level level, RadiantArrow arrow) {
        level.m_254849_(null, arrow.m_20185_(), arrow.m_20186_(), arrow.m_20189_(), 2.0f, Level.ExplosionInteraction.NONE);
        AABB explosionArea = new AABB(arrow.m_20185_() - 5.0, arrow.m_20186_() - 5.0, arrow.m_20189_() - 5.0, arrow.m_20185_() + 5.0, arrow.m_20186_() + 5.0, arrow.m_20189_() + 5.0);
        level.m_45976_(LivingEntity.class, explosionArea).forEach(entity -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = entity;
                DamageSource radiantSource = AncientSageDamageSource.createRadiantDamage(level, (Entity)arrow);
                if (livingEntity.m_21222_()) {
                    livingEntity.m_6469_(radiantSource, 6.0f);
                } else {
                    livingEntity.m_6469_(radiantSource, 3.0f);
                }
            }
        });
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }
}

