/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.function.Predicate;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TwinShadowsBow
extends BowItem {
    public TwinShadowsBow(Item.Properties properties) {
        super(properties);
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity livingEntity, int i) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            boolean hasInfinity = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)itemStack) > 0;
            ItemStack arrowStack = player.m_6298_(itemStack);
            if (!arrowStack.m_41619_() || hasInfinity) {
                boolean isCreativeArrow;
                if (arrowStack.m_41619_()) {
                    arrowStack = new ItemStack((ItemLike)Items.f_42412_);
                }
                int charge = this.m_8105_(itemStack) - i;
                float power = TwinShadowsBow.getPowerForTime(charge);
                if (charge < 20 || power < 1.0f) {
                    return;
                }
                boolean bl = isCreativeArrow = hasInfinity && arrowStack.m_150930_(Items.f_42412_);
                if (!level.f_46443_) {
                    this.fireTwinArrows(level, player, hasInfinity, itemStack, arrowStack);
                    itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                }
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.4f + 1.2f) + power * 0.5f);
                if (!(isCreativeArrow || hasInfinity || player.m_150110_().f_35937_)) {
                    arrowStack.m_41774_(2);
                    if (arrowStack.m_41619_()) {
                        player.m_150109_().m_36057_(arrowStack);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public static float getPowerForTime(int charge) {
        if (charge < 20) {
            return 0.0f;
        }
        float f = (float)charge / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    public int m_8105_(ItemStack itemStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        boolean bl;
        ItemStack itemStack = player.m_21120_(interactionHand);
        boolean bl2 = bl = !player.m_6298_(itemStack).m_41619_();
        if (!player.m_150110_().f_35937_ && !bl) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public Predicate<ItemStack> m_6437_() {
        return f_43005_;
    }

    public int m_6615_() {
        return 15;
    }

    private void fireTwinArrows(Level level, Player player, boolean hasInfinity, ItemStack bowStack, ItemStack arrowStack) {
        ArrowItem arrowItem = (ArrowItem)(arrowStack.m_41720_() instanceof ArrowItem ? arrowStack.m_41720_() : Items.f_42412_);
        AbstractArrow lightArrow = arrowItem.m_6394_(level, arrowStack, (LivingEntity)player);
        lightArrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
        lightArrow.m_36781_(4.0);
        lightArrow.m_6593_((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.WHITE) + "Light Arrow")));
        this.applyEnchantments(lightArrow, bowStack);
        lightArrow.f_36705_ = hasInfinity ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
        level.m_7967_((Entity)lightArrow);
        AbstractArrow darkArrow = arrowItem.m_6394_(level, arrowStack, (LivingEntity)player);
        darkArrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + 3.0f, 0.0f, 3.0f, 1.0f);
        darkArrow.m_36781_(6.0);
        darkArrow.m_6593_((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.DARK_GRAY) + "Dark Arrow")));
        this.applyEnchantments(darkArrow, bowStack);
        darkArrow.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        level.m_7967_((Entity)darkArrow);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void applyEnchantments(AbstractArrow arrow, ItemStack stack) {
        int punchLevel;
        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        if (powerLevel > 0) {
            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 1.5);
        }
        if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
            arrow.m_36735_(punchLevel);
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
            arrow.m_20254_(100);
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 15;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_150930_((Item)ItemRegistry.POWER_CRYSTAL.get());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"item.many_bows.twin_shadows.tooltip").m_130940_(ChatFormatting.AQUA));
            tooltip.add((Component)Component.m_237115_((String)"item.many_bows.twin_shadows.tooltip.ability").m_130940_(ChatFormatting.GOLD));
            tooltip.add((Component)Component.m_237115_((String)"item.many_bows.twin_shadows.tooltip.legend").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.too_many_bows.hold_shift"));
        }
    }
}

