/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.client.renderer;

import net.mayoi.radiationzonereborn.client.model.Modeldustorm;
import net.mayoi.radiationzonereborn.client.model.animations.dustormAnimation;
import net.mayoi.radiationzonereborn.entity.DustormEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class DustormRenderer
extends MobRenderer<DustormEntity, Modeldustorm<DustormEntity>> {
    public DustormRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modeldustorm.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(DustormEntity entity) {
        return ResourceLocation.parse((String)"radiation_zone_reborn:textures/entities/dustorm.png");
    }

    private static final class AnimatedModel
    extends Modeldustorm<DustormEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<DustormEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(DustormEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, dustormAnimation.idle, ageInTicks, 1.0f);
                this.animateWalk(dustormAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 5.0f);
                this.animate(entity.animationState2, dustormAnimation.attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(DustormEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

