/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mayoi.radiationzonereborn.client.model.Modelgiant_rat;
import net.mayoi.radiationzonereborn.client.model.animations.giant_ratAnimation;
import net.mayoi.radiationzonereborn.entity.GiantRatEntity;
import net.mayoi.radiationzonereborn.procedures.GiantRatAnimationRunProcedure;
import net.mayoi.radiationzonereborn.procedures.GiantRatAnimationWalkProcedure;
import net.mayoi.radiationzonereborn.procedures.GiantRatTooth2DisplayProcedure;
import net.mayoi.radiationzonereborn.procedures.GiantRatToothDisplayProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class GiantRatRenderer
extends MobRenderer<GiantRatEntity, Modelgiant_rat<GiantRatEntity>> {
    public GiantRatRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelgiant_rat.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<GiantRatEntity, Modelgiant_rat<GiantRatEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"radiation_zone_reborn:textures/entities/giant_rat_tooth.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, GiantRatEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (GiantRatToothDisplayProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelgiant_rat)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<GiantRatEntity, Modelgiant_rat<GiantRatEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"radiation_zone_reborn:textures/entities/giant_rat_tooth2.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, GiantRatEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (GiantRatTooth2DisplayProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelgiant_rat)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(GiantRatEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(GiantRatEntity entity) {
        return ResourceLocation.parse((String)"radiation_zone_reborn:textures/entities/giant_rat.png");
    }

    private static final class AnimatedModel
    extends Modelgiant_rat<GiantRatEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<GiantRatEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(GiantRatEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, giant_ratAnimation.tail, ageInTicks, 1.0f);
                if (GiantRatAnimationRunProcedure.execute((Entity)entity)) {
                    this.animateWalk(giant_ratAnimation.run, limbSwing, limbSwingAmount, 1.0f, 6.0f);
                }
                this.animate(entity.animationState2, giant_ratAnimation.idle_random, ageInTicks, 1.0f);
                if (GiantRatAnimationWalkProcedure.execute((Entity)entity)) {
                    this.animateWalk(giant_ratAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 12.0f);
                }
                this.animate(entity.animationState4, giant_ratAnimation.attack1, ageInTicks, 1.0f);
                this.animate(entity.animationState5, giant_ratAnimation.jump, ageInTicks, 1.0f);
                this.animate(entity.animationState6, giant_ratAnimation.jump2, ageInTicks, 1.0f);
                this.animate(entity.animationState7, giant_ratAnimation.jump3, ageInTicks, 1.0f);
                this.animate(entity.animationState8, giant_ratAnimation.sit, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(GiantRatEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

