/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModEntities;
import net.mayoi.radiationzonereborn.procedures.DecayedStoneCreeperAnimationAttackProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedStoneCreeperAnimationExplodeProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedStoneCreeperAnimationHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedStoneCreeperHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedStoneCreeperRandomWalkProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedStoneCreeperRightClickProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedStoneCreeperSpawnProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedStoneCreeperTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class DecayedStoneCreeperEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(DecayedStoneCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(DecayedStoneCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_explode = SynchedEntityData.defineId(DecayedStoneCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_explode_tick = SynchedEntityData.defineId(DecayedStoneCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_hurt = SynchedEntityData.defineId(DecayedStoneCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_hurt_tick = SynchedEntityData.defineId(DecayedStoneCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_has_target = SynchedEntityData.defineId(DecayedStoneCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_Pathfinding = SynchedEntityData.defineId(DecayedStoneCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_can_explode = SynchedEntityData.defineId(DecayedStoneCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();

    public DecayedStoneCreeperEntity(EntityType<DecayedStoneCreeperEntity> type, Level world) {
        super(type, world);
        this.xpReward = 5;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_in_explode, (Object)false);
        builder.define(DATA_explode_tick, (Object)0);
        builder.define(DATA_in_hurt, (Object)false);
        builder.define(DATA_hurt_tick, (Object)0);
        builder.define(DATA_has_target, (Object)0);
        builder.define(DATA_Pathfinding, (Object)false);
        builder.define(DATA_can_explode, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.4, 1.5));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = DecayedStoneCreeperEntity.this.getX();
                double y = DecayedStoneCreeperEntity.this.getY();
                double z = DecayedStoneCreeperEntity.this.getZ();
                DecayedStoneCreeperEntity entity = DecayedStoneCreeperEntity.this;
                Level world = DecayedStoneCreeperEntity.this.level();
                return super.canUse() && DecayedStoneCreeperRandomWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = DecayedStoneCreeperEntity.this.getX();
                double y = DecayedStoneCreeperEntity.this.getY();
                double z = DecayedStoneCreeperEntity.this.getZ();
                DecayedStoneCreeperEntity entity = DecayedStoneCreeperEntity.this;
                Level world = DecayedStoneCreeperEntity.this.level();
                return super.canContinueToUse() && DecayedStoneCreeperRandomWalkProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = DecayedStoneCreeperEntity.this.getX();
                double y = DecayedStoneCreeperEntity.this.getY();
                double z = DecayedStoneCreeperEntity.this.getZ();
                DecayedStoneCreeperEntity entity = DecayedStoneCreeperEntity.this;
                Level world = DecayedStoneCreeperEntity.this.level();
                return super.canUse() && DecayedStoneCreeperRandomWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = DecayedStoneCreeperEntity.this.getX();
                double y = DecayedStoneCreeperEntity.this.getY();
                double z = DecayedStoneCreeperEntity.this.getZ();
                DecayedStoneCreeperEntity entity = DecayedStoneCreeperEntity.this;
                Level world = DecayedStoneCreeperEntity.this.level();
                return super.canContinueToUse() && DecayedStoneCreeperRandomWalkProcedure.execute((Entity)entity);
            }
        });
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"radiation_zone_reborn:entity.decayed_giant.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"radiation_zone_reborn:entity.decayed_giant.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        DecayedStoneCreeperEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        DecayedStoneCreeperHurtProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, immediatesourceentity);
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (!world.isClientSide()) {
            LivingEntity livingAttacker;
            ItemStack weapon;
            Entity attacker = damagesource.getEntity();
            amount = attacker instanceof LivingEntity ? ((weapon = (livingAttacker = (LivingEntity)attacker).getMainHandItem()).getItem() instanceof PickaxeItem ? (amount *= 1.5f) : (amount *= 0.75f)) : (amount *= 0.75f);
            amount = Math.max(0.0f, amount);
        }
        return super.hurt(damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putBoolean("Datain_explode", ((Boolean)this.entityData.get(DATA_in_explode)).booleanValue());
        compound.putInt("Dataexplode_tick", ((Integer)this.entityData.get(DATA_explode_tick)).intValue());
        compound.putBoolean("Datain_hurt", ((Boolean)this.entityData.get(DATA_in_hurt)).booleanValue());
        compound.putInt("Datahurt_tick", ((Integer)this.entityData.get(DATA_hurt_tick)).intValue());
        compound.putInt("Datahas_target", ((Integer)this.entityData.get(DATA_has_target)).intValue());
        compound.putBoolean("DataPathfinding", ((Boolean)this.entityData.get(DATA_Pathfinding)).booleanValue());
        compound.putBoolean("Datacan_explode", ((Boolean)this.entityData.get(DATA_can_explode)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("Datain_explode")) {
            this.entityData.set(DATA_in_explode, (Object)compound.getBoolean("Datain_explode"));
        }
        if (compound.contains("Dataexplode_tick")) {
            this.entityData.set(DATA_explode_tick, (Object)compound.getInt("Dataexplode_tick"));
        }
        if (compound.contains("Datain_hurt")) {
            this.entityData.set(DATA_in_hurt, (Object)compound.getBoolean("Datain_hurt"));
        }
        if (compound.contains("Datahurt_tick")) {
            this.entityData.set(DATA_hurt_tick, (Object)compound.getInt("Datahurt_tick"));
        }
        if (compound.contains("Datahas_target")) {
            this.entityData.set(DATA_has_target, (Object)compound.getInt("Datahas_target"));
        }
        if (compound.contains("DataPathfinding")) {
            this.entityData.set(DATA_Pathfinding, (Object)compound.getBoolean("DataPathfinding"));
        }
        if (compound.contains("Datacan_explode")) {
            this.entityData.set(DATA_can_explode, (Object)compound.getBoolean("Datacan_explode"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        super.mobInteract(sourceentity, hand);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        DecayedStoneCreeperEntity entity = this;
        Level world = this.level();
        return DecayedStoneCreeperRightClickProcedure.execute((LevelAccessor)world, (Entity)entity, itemstack);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(DecayedStoneCreeperAnimationAttackProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(DecayedStoneCreeperAnimationExplodeProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(DecayedStoneCreeperAnimationHurtProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        DecayedStoneCreeperTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)RadiationZoneRebornModEntities.DECAYED_STONE_CREEPER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return DecayedStoneCreeperSpawnProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.21);
        builder = builder.add(Attributes.MAX_HEALTH, 22.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
        return builder;
    }
}

