/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModEntities;
import net.mayoi.radiationzonereborn.procedures.FumeshroomThrowerAnimationAttackProcedure;
import net.mayoi.radiationzonereborn.procedures.FumeshroomThrowerAnimationSitProcedure;
import net.mayoi.radiationzonereborn.procedures.FumeshroomThrowerAttackMonsterProcedure;
import net.mayoi.radiationzonereborn.procedures.FumeshroomThrowerCanFollowProcedure;
import net.mayoi.radiationzonereborn.procedures.FumeshroomThrowerCanRandomWalkProcedure;
import net.mayoi.radiationzonereborn.procedures.FumeshroomThrowerCanRunAwayProcedure;
import net.mayoi.radiationzonereborn.procedures.FumeshroomThrowerClickProcedure;
import net.mayoi.radiationzonereborn.procedures.FumeshroomThrowerTickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class FumeshroomThrowerEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(FumeshroomThrowerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(FumeshroomThrowerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_health = SynchedEntityData.defineId(FumeshroomThrowerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_has_target = SynchedEntityData.defineId(FumeshroomThrowerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_Pathfinding = SynchedEntityData.defineId(FumeshroomThrowerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_state = SynchedEntityData.defineId(FumeshroomThrowerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_cd = SynchedEntityData.defineId(FumeshroomThrowerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();

    public FumeshroomThrowerEntity(EntityType<FumeshroomThrowerEntity> type, Level world) {
        super(type, world);
        this.xpReward = 1;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_health, (Object)0);
        builder.define(DATA_has_target, (Object)0);
        builder.define(DATA_Pathfinding, (Object)false);
        builder.define(DATA_state, (Object)0);
        builder.define(DATA_attack_cd, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FollowOwnerGoal(this, 1.0, 6.0f, 2.0f){

            public boolean canUse() {
                double x = FumeshroomThrowerEntity.this.getX();
                double y = FumeshroomThrowerEntity.this.getY();
                double z = FumeshroomThrowerEntity.this.getZ();
                FumeshroomThrowerEntity entity = FumeshroomThrowerEntity.this;
                Level world = FumeshroomThrowerEntity.this.level();
                return super.canUse() && FumeshroomThrowerCanFollowProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FumeshroomThrowerEntity.this.getX();
                double y = FumeshroomThrowerEntity.this.getY();
                double z = FumeshroomThrowerEntity.this.getZ();
                FumeshroomThrowerEntity entity = FumeshroomThrowerEntity.this;
                Level world = FumeshroomThrowerEntity.this.level();
                return super.canContinueToUse() && FumeshroomThrowerCanFollowProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false, false){

            public boolean canUse() {
                double x = FumeshroomThrowerEntity.this.getX();
                double y = FumeshroomThrowerEntity.this.getY();
                double z = FumeshroomThrowerEntity.this.getZ();
                FumeshroomThrowerEntity entity = FumeshroomThrowerEntity.this;
                Level world = FumeshroomThrowerEntity.this.level();
                return super.canUse() && FumeshroomThrowerAttackMonsterProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FumeshroomThrowerEntity.this.getX();
                double y = FumeshroomThrowerEntity.this.getY();
                double z = FumeshroomThrowerEntity.this.getZ();
                FumeshroomThrowerEntity entity = FumeshroomThrowerEntity.this;
                Level world = FumeshroomThrowerEntity.this.level();
                return super.canContinueToUse() && FumeshroomThrowerAttackMonsterProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new AvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, e -> this.getTarget() == e, 10.0f, 1.3, 1.3, e -> this.getTarget() == e){

            public boolean canUse() {
                double x = FumeshroomThrowerEntity.this.getX();
                double y = FumeshroomThrowerEntity.this.getY();
                double z = FumeshroomThrowerEntity.this.getZ();
                FumeshroomThrowerEntity entity = FumeshroomThrowerEntity.this;
                Level world = FumeshroomThrowerEntity.this.level();
                return super.canUse() && FumeshroomThrowerCanRunAwayProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FumeshroomThrowerEntity.this.getX();
                double y = FumeshroomThrowerEntity.this.getY();
                double z = FumeshroomThrowerEntity.this.getZ();
                FumeshroomThrowerEntity entity = FumeshroomThrowerEntity.this;
                Level world = FumeshroomThrowerEntity.this.level();
                return super.canContinueToUse() && FumeshroomThrowerCanRunAwayProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = FumeshroomThrowerEntity.this.getX();
                double y = FumeshroomThrowerEntity.this.getY();
                double z = FumeshroomThrowerEntity.this.getZ();
                FumeshroomThrowerEntity entity = FumeshroomThrowerEntity.this;
                Level world = FumeshroomThrowerEntity.this.level();
                return super.canUse() && FumeshroomThrowerCanRandomWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FumeshroomThrowerEntity.this.getX();
                double y = FumeshroomThrowerEntity.this.getY();
                double z = FumeshroomThrowerEntity.this.getZ();
                FumeshroomThrowerEntity entity = FumeshroomThrowerEntity.this;
                Level world = FumeshroomThrowerEntity.this.level();
                return super.canContinueToUse() && FumeshroomThrowerCanRandomWalkProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = FumeshroomThrowerEntity.this.getX();
                double y = FumeshroomThrowerEntity.this.getY();
                double z = FumeshroomThrowerEntity.this.getZ();
                FumeshroomThrowerEntity entity = FumeshroomThrowerEntity.this;
                Level world = FumeshroomThrowerEntity.this.level();
                return super.canUse() && FumeshroomThrowerCanRandomWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FumeshroomThrowerEntity.this.getX();
                double y = FumeshroomThrowerEntity.this.getY();
                double z = FumeshroomThrowerEntity.this.getZ();
                FumeshroomThrowerEntity entity = FumeshroomThrowerEntity.this;
                Level world = FumeshroomThrowerEntity.this.level();
                return super.canContinueToUse() && FumeshroomThrowerCanRandomWalkProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.stem.hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.stem.break"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putInt("Datahealth", ((Integer)this.entityData.get(DATA_health)).intValue());
        compound.putInt("Datahas_target", ((Integer)this.entityData.get(DATA_has_target)).intValue());
        compound.putBoolean("DataPathfinding", ((Boolean)this.entityData.get(DATA_Pathfinding)).booleanValue());
        compound.putInt("Datastate", ((Integer)this.entityData.get(DATA_state)).intValue());
        compound.putInt("Dataattack_cd", ((Integer)this.entityData.get(DATA_attack_cd)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("Datahealth")) {
            this.entityData.set(DATA_health, (Object)compound.getInt("Datahealth"));
        }
        if (compound.contains("Datahas_target")) {
            this.entityData.set(DATA_has_target, (Object)compound.getInt("Datahas_target"));
        }
        if (compound.contains("DataPathfinding")) {
            this.entityData.set(DATA_Pathfinding, (Object)compound.getBoolean("DataPathfinding"));
        }
        if (compound.contains("Datastate")) {
            this.entityData.set(DATA_state, (Object)compound.getInt("Datastate"));
        }
        if (compound.contains("Dataattack_cd")) {
            this.entityData.set(DATA_attack_cd, (Object)compound.getInt("Dataattack_cd"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        FumeshroomThrowerEntity entity = this;
        Level world = this.level();
        return FumeshroomThrowerClickProcedure.execute((Entity)entity, (Entity)sourceentity);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(FumeshroomThrowerAnimationAttackProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(true, this.tickCount);
            this.animationState3.animateWhen(FumeshroomThrowerAnimationSitProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        FumeshroomThrowerTickProcedure.execute(this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        FumeshroomThrowerEntity retval = (FumeshroomThrowerEntity)((EntityType)RadiationZoneRebornModEntities.FUMESHROOM_THROWER.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.BARRIER)}).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)RadiationZoneRebornModEntities.FUMESHROOM_THROWER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.26);
        builder = builder.add(Attributes.MAX_HEALTH, 28.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.3);
        return builder;
    }
}

