/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModEntities;
import net.mayoi.radiationzonereborn.procedures.FumeshroomWarriorAnimationAttackProcedure;
import net.mayoi.radiationzonereborn.procedures.FumeshroomWarriorAnimationSitProcedure;
import net.mayoi.radiationzonereborn.procedures.FumeshroomWarriorAttackMonsterProcedure;
import net.mayoi.radiationzonereborn.procedures.FumeshroomWarriorCanFollowProcedure;
import net.mayoi.radiationzonereborn.procedures.FumeshroomWarriorCanRandomWalkProcedure;
import net.mayoi.radiationzonereborn.procedures.FumeshroomWarriorClickProcedure;
import net.mayoi.radiationzonereborn.procedures.FumeshroomWarriorTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class FumeshroomWarriorEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(FumeshroomWarriorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(FumeshroomWarriorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_health = SynchedEntityData.defineId(FumeshroomWarriorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_has_target = SynchedEntityData.defineId(FumeshroomWarriorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_Pathfinding = SynchedEntityData.defineId(FumeshroomWarriorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_state = SynchedEntityData.defineId(FumeshroomWarriorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();

    public FumeshroomWarriorEntity(EntityType<FumeshroomWarriorEntity> type, Level world) {
        super(type, world);
        this.xpReward = 1;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_health, (Object)0);
        builder.define(DATA_has_target, (Object)0);
        builder.define(DATA_Pathfinding, (Object)false);
        builder.define(DATA_state, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FollowOwnerGoal(this, 1.0, 6.0f, 2.0f){

            public boolean canUse() {
                double x = FumeshroomWarriorEntity.this.getX();
                double y = FumeshroomWarriorEntity.this.getY();
                double z = FumeshroomWarriorEntity.this.getZ();
                FumeshroomWarriorEntity entity = FumeshroomWarriorEntity.this;
                Level world = FumeshroomWarriorEntity.this.level();
                return super.canUse() && FumeshroomWarriorCanFollowProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FumeshroomWarriorEntity.this.getX();
                double y = FumeshroomWarriorEntity.this.getY();
                double z = FumeshroomWarriorEntity.this.getZ();
                FumeshroomWarriorEntity entity = FumeshroomWarriorEntity.this;
                Level world = FumeshroomWarriorEntity.this.level();
                return super.canContinueToUse() && FumeshroomWarriorCanFollowProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false, false){

            public boolean canUse() {
                double x = FumeshroomWarriorEntity.this.getX();
                double y = FumeshroomWarriorEntity.this.getY();
                double z = FumeshroomWarriorEntity.this.getZ();
                FumeshroomWarriorEntity entity = FumeshroomWarriorEntity.this;
                Level world = FumeshroomWarriorEntity.this.level();
                return super.canUse() && FumeshroomWarriorAttackMonsterProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FumeshroomWarriorEntity.this.getX();
                double y = FumeshroomWarriorEntity.this.getY();
                double z = FumeshroomWarriorEntity.this.getZ();
                FumeshroomWarriorEntity entity = FumeshroomWarriorEntity.this;
                Level world = FumeshroomWarriorEntity.this.level();
                return super.canContinueToUse() && FumeshroomWarriorAttackMonsterProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = FumeshroomWarriorEntity.this.getX();
                double y = FumeshroomWarriorEntity.this.getY();
                double z = FumeshroomWarriorEntity.this.getZ();
                FumeshroomWarriorEntity entity = FumeshroomWarriorEntity.this;
                Level world = FumeshroomWarriorEntity.this.level();
                return super.canUse() && FumeshroomWarriorCanRandomWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FumeshroomWarriorEntity.this.getX();
                double y = FumeshroomWarriorEntity.this.getY();
                double z = FumeshroomWarriorEntity.this.getZ();
                FumeshroomWarriorEntity entity = FumeshroomWarriorEntity.this;
                Level world = FumeshroomWarriorEntity.this.level();
                return super.canContinueToUse() && FumeshroomWarriorCanRandomWalkProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = FumeshroomWarriorEntity.this.getX();
                double y = FumeshroomWarriorEntity.this.getY();
                double z = FumeshroomWarriorEntity.this.getZ();
                FumeshroomWarriorEntity entity = FumeshroomWarriorEntity.this;
                Level world = FumeshroomWarriorEntity.this.level();
                return super.canUse() && FumeshroomWarriorCanRandomWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FumeshroomWarriorEntity.this.getX();
                double y = FumeshroomWarriorEntity.this.getY();
                double z = FumeshroomWarriorEntity.this.getZ();
                FumeshroomWarriorEntity entity = FumeshroomWarriorEntity.this;
                Level world = FumeshroomWarriorEntity.this.level();
                return super.canContinueToUse() && FumeshroomWarriorCanRandomWalkProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.stem.hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.stem.break"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putInt("Datahealth", ((Integer)this.entityData.get(DATA_health)).intValue());
        compound.putInt("Datahas_target", ((Integer)this.entityData.get(DATA_has_target)).intValue());
        compound.putBoolean("DataPathfinding", ((Boolean)this.entityData.get(DATA_Pathfinding)).booleanValue());
        compound.putInt("Datastate", ((Integer)this.entityData.get(DATA_state)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("Datahealth")) {
            this.entityData.set(DATA_health, (Object)compound.getInt("Datahealth"));
        }
        if (compound.contains("Datahas_target")) {
            this.entityData.set(DATA_has_target, (Object)compound.getInt("Datahas_target"));
        }
        if (compound.contains("DataPathfinding")) {
            this.entityData.set(DATA_Pathfinding, (Object)compound.getBoolean("DataPathfinding"));
        }
        if (compound.contains("Datastate")) {
            this.entityData.set(DATA_state, (Object)compound.getInt("Datastate"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        FumeshroomWarriorEntity entity = this;
        Level world = this.level();
        return FumeshroomWarriorClickProcedure.execute((Entity)entity, (Entity)sourceentity);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(FumeshroomWarriorAnimationAttackProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(true, this.tickCount);
            this.animationState3.animateWhen(FumeshroomWarriorAnimationSitProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        FumeshroomWarriorTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        FumeshroomWarriorEntity retval = (FumeshroomWarriorEntity)((EntityType)RadiationZoneRebornModEntities.FUMESHROOM_WARRIOR.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.BARRIER)}).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.23);
        builder = builder.add(Attributes.MAX_HEALTH, 42.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 5.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.3);
        return builder;
    }
}

