/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import javax.annotation.Nullable;
import net.mayoi.radiationzonereborn.procedures.IrradiantAnimationAttack1Procedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantAnimationAttack2Procedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantAnimationAttack3Procedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantAnimationAttack4Procedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantAnimationAttack5Procedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantAnimationHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantAnimationIdlePhase2Procedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantAnimationIdlePhase3Procedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantAnimationShieldHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantRandomAttackProcedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantShieldBreakProcedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantShieldHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantTickProcedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantWhenSpawnProcedure;
import net.mayoi.radiationzonereborn.procedures.IrrdiantDeathProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class IrradiantEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_has_target = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_Pathfinding = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_shield_hurt_tick = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_hurt_tick = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_shield_health = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_shield_number = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_attack_type = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_recover_shield_CD = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_hurt = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_in_shield_hurt = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_shield_hurt_cd = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_particle = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_rush_CD = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_spawn_number = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_spawn_CD = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_speed = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_recover_tick = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_has_target_recover = SynchedEntityData.defineId(IrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();
    public final AnimationState animationState7 = new AnimationState();
    public final AnimationState animationState8 = new AnimationState();
    public final AnimationState animationState9 = new AnimationState();

    public IrradiantEntity(EntityType<IrradiantEntity> type, Level world) {
        super(type, world);
        this.xpReward = 30;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_has_target, (Object)0);
        builder.define(DATA_Pathfinding, (Object)false);
        builder.define(DATA_shield_hurt_tick, (Object)0);
        builder.define(DATA_hurt_tick, (Object)0);
        builder.define(DATA_shield_health, (Object)0);
        builder.define(DATA_shield_number, (Object)5);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_attack_type, (Object)0);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_recover_shield_CD, (Object)300);
        builder.define(DATA_in_hurt, (Object)false);
        builder.define(DATA_in_shield_hurt, (Object)false);
        builder.define(DATA_shield_hurt_cd, (Object)0);
        builder.define(DATA_particle, (Object)0);
        builder.define(DATA_rush_CD, (Object)100);
        builder.define(DATA_spawn_number, (Object)0);
        builder.define(DATA_spawn_CD, (Object)0);
        builder.define(DATA_speed, (Object)0);
        builder.define(DATA_recover_tick, (Object)0);
        builder.define(DATA_has_target_recover, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = IrradiantEntity.this.getX();
                double y = IrradiantEntity.this.getY();
                double z = IrradiantEntity.this.getZ();
                IrradiantEntity entity = IrradiantEntity.this;
                Level world = IrradiantEntity.this.level();
                return super.canUse() && IrradiantRandomAttackProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = IrradiantEntity.this.getX();
                double y = IrradiantEntity.this.getY();
                double z = IrradiantEntity.this.getZ();
                IrradiantEntity entity = IrradiantEntity.this;
                Level world = IrradiantEntity.this.level();
                return super.canContinueToUse() && IrradiantRandomAttackProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.amethyst_block.place"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.amethyst_block.hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.amethyst_block.break"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        IrradiantEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        Entity direct = damagesource.getDirectEntity();
        if (direct instanceof Projectile && (Integer)this.entityData.get(DATA_shield_number) > 0) {
            if (!((Boolean)this.entityData.get(DATA_in_shield_hurt)).booleanValue()) {
                this.entityData.set(DATA_in_shield_hurt, (Object)true);
            }
            IrradiantShieldHurtProcedure.execute((LevelAccessor)world, x, y, z);
            return false;
        }
        if ((Integer)this.entityData.get(DATA_attack_type) == 4 && ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue() && !damagesource.is(TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"minecraft:bypasses_shield")))) {
            IrradiantShieldHurtProcedure.execute((LevelAccessor)world, x, y, z);
            return false;
        }
        IrradiantHurtProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, immediatesourceentity);
        if (!world.isClientSide()) {
            LivingEntity livingAttacker;
            ItemStack weapon;
            Entity attacker = damagesource.getEntity();
            if ((Integer)this.entityData.get(DATA_attack_type) == 4 && ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue()) {
                amount *= 0.5f;
            }
            amount = attacker instanceof LivingEntity ? ((weapon = (livingAttacker = (LivingEntity)attacker).getMainHandItem()).getItem() instanceof PickaxeItem ? (amount *= 1.5f) : (amount *= 0.75f)) : (amount *= 0.75f);
            amount = Math.max(0.0f, amount);
            ItemStack weapon2 = null;
            if (attacker instanceof LivingEntity) {
                LivingEntity livingAttacker2 = (LivingEntity)attacker;
                weapon2 = livingAttacker2.getMainHandItem();
            }
            if (damagesource.is(TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"minecraft:bypasses_shield")))) {
                return super.hurt(damagesource, amount);
            }
            if ((Integer)this.entityData.get(DATA_shield_hurt_cd) > 0 && !damagesource.is(TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"minecraft:bypasses_cooldown"))) && (Integer)this.entityData.get(DATA_shield_number) > 0) {
                return false;
            }
            if ((Integer)this.entityData.get(DATA_shield_hurt_cd) > 0 && !damagesource.is(TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"minecraft:bypasses_cooldown")))) {
                return false;
            }
            if ((Integer)this.entityData.get(DATA_shield_number) > 0) {
                this.entityData.set(DATA_shield_health, (Object)((Integer)this.entityData.get(DATA_shield_health) - (int)amount));
                if (weapon2 != null && (weapon2.getItem() instanceof PickaxeItem || (Integer)this.entityData.get(DATA_shield_health) <= 0)) {
                    LivingEntity _livingEntity6;
                    this.entityData.set(DATA_shield_number, (Object)((Integer)this.entityData.get(DATA_shield_number) - 1));
                    IrradiantShieldBreakProcedure.execute((LevelAccessor)world, x, y, z, immediatesourceentity);
                    this.entityData.set(DATA_shield_health, (Object)((int)((double)Math.round(entity instanceof LivingEntity && (_livingEntity6 = (LivingEntity)entity).getAttributes().hasAttribute(Attributes.MAX_HEALTH) ? _livingEntity6.getAttribute(Attributes.MAX_HEALTH).getValue() : 0.0) * 0.4)));
                } else {
                    if (!((Boolean)this.entityData.get(DATA_in_shield_hurt)).booleanValue()) {
                        this.entityData.set(DATA_in_shield_hurt, (Object)true);
                    }
                    IrradiantShieldHurtProcedure.execute((LevelAccessor)world, x, y, z);
                }
                this.entityData.set(DATA_shield_hurt_cd, (Object)10);
                return false;
            }
            return super.hurt(damagesource, amount);
        }
        return super.hurt(damagesource, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        IrrdiantDeathProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        IrradiantWhenSpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Datahas_target", ((Integer)this.entityData.get(DATA_has_target)).intValue());
        compound.putBoolean("DataPathfinding", ((Boolean)this.entityData.get(DATA_Pathfinding)).booleanValue());
        compound.putInt("Datashield_hurt_tick", ((Integer)this.entityData.get(DATA_shield_hurt_tick)).intValue());
        compound.putInt("Datahurt_tick", ((Integer)this.entityData.get(DATA_hurt_tick)).intValue());
        compound.putInt("Datashield_health", ((Integer)this.entityData.get(DATA_shield_health)).intValue());
        compound.putInt("Datashield_number", ((Integer)this.entityData.get(DATA_shield_number)).intValue());
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putInt("Dataattack_type", ((Integer)this.entityData.get(DATA_attack_type)).intValue());
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putInt("Datarecover_shield_CD", ((Integer)this.entityData.get(DATA_recover_shield_CD)).intValue());
        compound.putBoolean("Datain_hurt", ((Boolean)this.entityData.get(DATA_in_hurt)).booleanValue());
        compound.putBoolean("Datain_shield_hurt", ((Boolean)this.entityData.get(DATA_in_shield_hurt)).booleanValue());
        compound.putInt("Datashield_hurt_cd", ((Integer)this.entityData.get(DATA_shield_hurt_cd)).intValue());
        compound.putInt("Dataparticle", ((Integer)this.entityData.get(DATA_particle)).intValue());
        compound.putInt("Datarush_CD", ((Integer)this.entityData.get(DATA_rush_CD)).intValue());
        compound.putInt("Dataspawn_number", ((Integer)this.entityData.get(DATA_spawn_number)).intValue());
        compound.putInt("Dataspawn_CD", ((Integer)this.entityData.get(DATA_spawn_CD)).intValue());
        compound.putInt("Dataspeed", ((Integer)this.entityData.get(DATA_speed)).intValue());
        compound.putInt("Datarecover_tick", ((Integer)this.entityData.get(DATA_recover_tick)).intValue());
        compound.putInt("Datahas_target_recover", ((Integer)this.entityData.get(DATA_has_target_recover)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datahas_target")) {
            this.entityData.set(DATA_has_target, (Object)compound.getInt("Datahas_target"));
        }
        if (compound.contains("DataPathfinding")) {
            this.entityData.set(DATA_Pathfinding, (Object)compound.getBoolean("DataPathfinding"));
        }
        if (compound.contains("Datashield_hurt_tick")) {
            this.entityData.set(DATA_shield_hurt_tick, (Object)compound.getInt("Datashield_hurt_tick"));
        }
        if (compound.contains("Datahurt_tick")) {
            this.entityData.set(DATA_hurt_tick, (Object)compound.getInt("Datahurt_tick"));
        }
        if (compound.contains("Datashield_health")) {
            this.entityData.set(DATA_shield_health, (Object)compound.getInt("Datashield_health"));
        }
        if (compound.contains("Datashield_number")) {
            this.entityData.set(DATA_shield_number, (Object)compound.getInt("Datashield_number"));
        }
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("Dataattack_type")) {
            this.entityData.set(DATA_attack_type, (Object)compound.getInt("Dataattack_type"));
        }
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("Datarecover_shield_CD")) {
            this.entityData.set(DATA_recover_shield_CD, (Object)compound.getInt("Datarecover_shield_CD"));
        }
        if (compound.contains("Datain_hurt")) {
            this.entityData.set(DATA_in_hurt, (Object)compound.getBoolean("Datain_hurt"));
        }
        if (compound.contains("Datain_shield_hurt")) {
            this.entityData.set(DATA_in_shield_hurt, (Object)compound.getBoolean("Datain_shield_hurt"));
        }
        if (compound.contains("Datashield_hurt_cd")) {
            this.entityData.set(DATA_shield_hurt_cd, (Object)compound.getInt("Datashield_hurt_cd"));
        }
        if (compound.contains("Dataparticle")) {
            this.entityData.set(DATA_particle, (Object)compound.getInt("Dataparticle"));
        }
        if (compound.contains("Datarush_CD")) {
            this.entityData.set(DATA_rush_CD, (Object)compound.getInt("Datarush_CD"));
        }
        if (compound.contains("Dataspawn_number")) {
            this.entityData.set(DATA_spawn_number, (Object)compound.getInt("Dataspawn_number"));
        }
        if (compound.contains("Dataspawn_CD")) {
            this.entityData.set(DATA_spawn_CD, (Object)compound.getInt("Dataspawn_CD"));
        }
        if (compound.contains("Dataspeed")) {
            this.entityData.set(DATA_speed, (Object)compound.getInt("Dataspeed"));
        }
        if (compound.contains("Datarecover_tick")) {
            this.entityData.set(DATA_recover_tick, (Object)compound.getInt("Datarecover_tick"));
        }
        if (compound.contains("Datahas_target_recover")) {
            this.entityData.set(DATA_has_target_recover, (Object)compound.getInt("Datahas_target_recover"));
        }
    }

    public void tick() {
        LivingEntity target;
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState1.animateWhen(IrradiantAnimationIdlePhase2Procedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(IrradiantAnimationIdlePhase3Procedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(IrradiantAnimationAttack1Procedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(IrradiantAnimationAttack2Procedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(IrradiantAnimationAttack3Procedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(IrradiantAnimationAttack4Procedure.execute((Entity)this), this.tickCount);
            this.animationState7.animateWhen(IrradiantAnimationAttack5Procedure.execute((Entity)this), this.tickCount);
            this.animationState8.animateWhen(IrradiantAnimationShieldHurtProcedure.execute((Entity)this), this.tickCount);
            this.animationState9.animateWhen(IrradiantAnimationHurtProcedure.execute((Entity)this), this.tickCount);
        }
        if (!((target = this.getTarget()) == null || target.isAlive() && !(target.getHealth() <= 0.0f) && this.canAttack(target))) {
            this.setTarget(null);
        }
    }

    public void baseTick() {
        super.baseTick();
        IrradiantTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.1f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 100.0);
        builder = builder.add(Attributes.ARMOR, 4.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 10.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        return builder;
    }
}

