/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModEntities;
import net.mayoi.radiationzonereborn.procedures.StonecrawCrabAnimationAttack2Procedure;
import net.mayoi.radiationzonereborn.procedures.StonecrawCrabAnimationAttackProcedure;
import net.mayoi.radiationzonereborn.procedures.StonecrawCrabAnimationHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.StonecrawCrabCanWalkProcedure;
import net.mayoi.radiationzonereborn.procedures.StonecrawCrabHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.StonecrawCrabSpawnProcedure;
import net.mayoi.radiationzonereborn.procedures.StonecrawCrabTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class StonecrawCrabEntity
extends PathfinderMob {
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(StonecrawCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_attack_type = SynchedEntityData.defineId(StonecrawCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(StonecrawCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_Pathfinding = SynchedEntityData.defineId(StonecrawCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_health = SynchedEntityData.defineId(StonecrawCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_has_target = SynchedEntityData.defineId(StonecrawCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_hurt_tick = SynchedEntityData.defineId(StonecrawCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_hurt = SynchedEntityData.defineId(StonecrawCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();

    public StonecrawCrabEntity(EntityType<StonecrawCrabEntity> type, Level world) {
        super(type, world);
        this.xpReward = 4;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_attack_type, (Object)0);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_Pathfinding, (Object)false);
        builder.define(DATA_health, (Object)0);
        builder.define(DATA_has_target, (Object)0);
        builder.define(DATA_hurt_tick, (Object)0);
        builder.define(DATA_in_hurt, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, e -> this.getTarget() == e, 7.0f, 1.8, 1.8, e -> this.getTarget() == e){

            public boolean canUse() {
                double x = StonecrawCrabEntity.this.getX();
                double y = StonecrawCrabEntity.this.getY();
                double z = StonecrawCrabEntity.this.getZ();
                StonecrawCrabEntity entity = StonecrawCrabEntity.this;
                Level world = StonecrawCrabEntity.this.level();
                return super.canUse() && StonecrawCrabCanWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = StonecrawCrabEntity.this.getX();
                double y = StonecrawCrabEntity.this.getY();
                double z = StonecrawCrabEntity.this.getZ();
                StonecrawCrabEntity entity = StonecrawCrabEntity.this;
                Level world = StonecrawCrabEntity.this.level();
                return super.canContinueToUse() && StonecrawCrabCanWalkProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal(this, 1.0){

            public boolean canUse() {
                double x = StonecrawCrabEntity.this.getX();
                double y = StonecrawCrabEntity.this.getY();
                double z = StonecrawCrabEntity.this.getZ();
                StonecrawCrabEntity entity = StonecrawCrabEntity.this;
                Level world = StonecrawCrabEntity.this.level();
                return super.canUse() && StonecrawCrabCanWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = StonecrawCrabEntity.this.getX();
                double y = StonecrawCrabEntity.this.getY();
                double z = StonecrawCrabEntity.this.getZ();
                StonecrawCrabEntity entity = StonecrawCrabEntity.this;
                Level world = StonecrawCrabEntity.this.level();
                return super.canContinueToUse() && StonecrawCrabCanWalkProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = StonecrawCrabEntity.this.getX();
                double y = StonecrawCrabEntity.this.getY();
                double z = StonecrawCrabEntity.this.getZ();
                StonecrawCrabEntity entity = StonecrawCrabEntity.this;
                Level world = StonecrawCrabEntity.this.level();
                return super.canUse() && StonecrawCrabCanWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = StonecrawCrabEntity.this.getX();
                double y = StonecrawCrabEntity.this.getY();
                double z = StonecrawCrabEntity.this.getZ();
                StonecrawCrabEntity entity = StonecrawCrabEntity.this;
                Level world = StonecrawCrabEntity.this.level();
                return super.canContinueToUse() && StonecrawCrabCanWalkProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.dripstone_block.hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.dripstone_block.break"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        StonecrawCrabEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        StonecrawCrabHurtProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, immediatesourceentity);
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FREEZE)) {
            return false;
        }
        if (!world.isClientSide()) {
            LivingEntity livingAttacker;
            ItemStack weapon;
            Entity attacker = damagesource.getEntity();
            amount = attacker instanceof LivingEntity ? ((weapon = (livingAttacker = (LivingEntity)attacker).getMainHandItem()).getItem() instanceof PickaxeItem ? (amount *= 1.5f) : (amount *= 0.75f)) : (amount *= 0.75f);
            amount = Math.max(0.0f, amount);
        }
        return super.hurt(damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putInt("Dataattack_type", ((Integer)this.entityData.get(DATA_attack_type)).intValue());
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putBoolean("DataPathfinding", ((Boolean)this.entityData.get(DATA_Pathfinding)).booleanValue());
        compound.putInt("Datahealth", ((Integer)this.entityData.get(DATA_health)).intValue());
        compound.putInt("Datahas_target", ((Integer)this.entityData.get(DATA_has_target)).intValue());
        compound.putInt("Datahurt_tick", ((Integer)this.entityData.get(DATA_hurt_tick)).intValue());
        compound.putBoolean("Datain_hurt", ((Boolean)this.entityData.get(DATA_in_hurt)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("Dataattack_type")) {
            this.entityData.set(DATA_attack_type, (Object)compound.getInt("Dataattack_type"));
        }
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("DataPathfinding")) {
            this.entityData.set(DATA_Pathfinding, (Object)compound.getBoolean("DataPathfinding"));
        }
        if (compound.contains("Datahealth")) {
            this.entityData.set(DATA_health, (Object)compound.getInt("Datahealth"));
        }
        if (compound.contains("Datahas_target")) {
            this.entityData.set(DATA_has_target, (Object)compound.getInt("Datahas_target"));
        }
        if (compound.contains("Datahurt_tick")) {
            this.entityData.set(DATA_hurt_tick, (Object)compound.getInt("Datahurt_tick"));
        }
        if (compound.contains("Datain_hurt")) {
            this.entityData.set(DATA_in_hurt, (Object)compound.getBoolean("Datain_hurt"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(StonecrawCrabAnimationAttackProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(StonecrawCrabAnimationAttack2Procedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(StonecrawCrabAnimationHurtProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        StonecrawCrabTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)RadiationZoneRebornModEntities.STONECRAW_CRAB.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return StonecrawCrabSpawnProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.22);
        builder = builder.add(Attributes.MAX_HEALTH, 28.0);
        builder = builder.add(Attributes.ARMOR, 6.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 2.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 20.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        return builder;
    }
}

