/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import net.mayoi.radiationzonereborn.entity.DesertRainFrogEntity;
import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModEntities;
import net.mayoi.radiationzonereborn.procedures.VesicabugAnimationAttackProcedure;
import net.mayoi.radiationzonereborn.procedures.VesicabugAnimationFlyProcedure;
import net.mayoi.radiationzonereborn.procedures.VesicabugAnimationHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.VesicabugAvoidEntityProcedure;
import net.mayoi.radiationzonereborn.procedures.VesicabugHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.VesicabugSpawnProcedure;
import net.mayoi.radiationzonereborn.procedures.VesicabugTickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class VesicabugEntity
extends PathfinderMob {
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(VesicabugEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(VesicabugEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_hurt_tick = SynchedEntityData.defineId(VesicabugEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_hurt = SynchedEntityData.defineId(VesicabugEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_has_target = SynchedEntityData.defineId(VesicabugEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_recover_tick = SynchedEntityData.defineId(VesicabugEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_in_hurt_tick = SynchedEntityData.defineId(VesicabugEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();

    public VesicabugEntity(EntityType<VesicabugEntity> type, Level world) {
        super(type, world);
        this.xpReward = 5;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_hurt_tick, (Object)0);
        builder.define(DATA_in_hurt, (Object)false);
        builder.define(DATA_has_target, (Object)0);
        builder.define(DATA_recover_tick, (Object)0);
        builder.define(DATA_in_hurt_tick, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, DesertRainFrogEntity.class, 4.0f, 1.0, 1.0));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, e -> this.getTarget() == e, 10.0f, 1.5, 1.5, e -> this.getTarget() == e){

            public boolean canUse() {
                double x = VesicabugEntity.this.getX();
                double y = VesicabugEntity.this.getY();
                double z = VesicabugEntity.this.getZ();
                VesicabugEntity entity = VesicabugEntity.this;
                Level world = VesicabugEntity.this.level();
                return super.canUse() && VesicabugAvoidEntityProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = VesicabugEntity.this.getX();
                double y = VesicabugEntity.this.getY();
                double z = VesicabugEntity.this.getZ();
                VesicabugEntity entity = VesicabugEntity.this;
                Level world = VesicabugEntity.this.level();
                return super.canContinueToUse() && VesicabugAvoidEntityProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.spider.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.spider.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.spider.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        VesicabugEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        VesicabugHurtProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return super.hurt(damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putInt("Datahurt_tick", ((Integer)this.entityData.get(DATA_hurt_tick)).intValue());
        compound.putBoolean("Datain_hurt", ((Boolean)this.entityData.get(DATA_in_hurt)).booleanValue());
        compound.putInt("Datahas_target", ((Integer)this.entityData.get(DATA_has_target)).intValue());
        compound.putInt("Datarecover_tick", ((Integer)this.entityData.get(DATA_recover_tick)).intValue());
        compound.putInt("Datain_hurt_tick", ((Integer)this.entityData.get(DATA_in_hurt_tick)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("Datahurt_tick")) {
            this.entityData.set(DATA_hurt_tick, (Object)compound.getInt("Datahurt_tick"));
        }
        if (compound.contains("Datain_hurt")) {
            this.entityData.set(DATA_in_hurt, (Object)compound.getBoolean("Datain_hurt"));
        }
        if (compound.contains("Datahas_target")) {
            this.entityData.set(DATA_has_target, (Object)compound.getInt("Datahas_target"));
        }
        if (compound.contains("Datarecover_tick")) {
            this.entityData.set(DATA_recover_tick, (Object)compound.getInt("Datarecover_tick"));
        }
        if (compound.contains("Datain_hurt_tick")) {
            this.entityData.set(DATA_in_hurt_tick, (Object)compound.getInt("Datain_hurt_tick"));
        }
    }

    public void tick() {
        LivingEntity target;
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState1.animateWhen(true, this.tickCount);
            this.animationState3.animateWhen(VesicabugAnimationFlyProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(VesicabugAnimationAttackProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(VesicabugAnimationHurtProcedure.execute((Entity)this), this.tickCount);
        }
        if (!((target = this.getTarget()) == null || target.isAlive() && !(target.getHealth() <= 0.0f) && this.canAttack(target))) {
            this.setTarget(null);
        }
    }

    public void baseTick() {
        super.baseTick();
        VesicabugTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)RadiationZoneRebornModEntities.VESICABUG.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return VesicabugSpawnProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.27);
        builder = builder.add(Attributes.MAX_HEALTH, 18.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        return builder;
    }
}

