/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModEntities;
import net.mayoi.radiationzonereborn.procedures.WalkingFumeshroomAnimationHasItemProcedure;
import net.mayoi.radiationzonereborn.procedures.WalkingFumeshroomRightClickProcedure;
import net.mayoi.radiationzonereborn.procedures.WalkingFumeshroomSpawnProcedure;
import net.mayoi.radiationzonereborn.procedures.WalkingFumeshroomTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class WalkingFumeshroomEntity
extends PathfinderMob {
    public static final EntityDataAccessor<Boolean> DATA_has_item = SynchedEntityData.defineId(WalkingFumeshroomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_Grow = SynchedEntityData.defineId(WalkingFumeshroomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_grow_warrior = SynchedEntityData.defineId(WalkingFumeshroomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_grow_thrower = SynchedEntityData.defineId(WalkingFumeshroomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_twm_number = SynchedEntityData.defineId(WalkingFumeshroomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState2 = new AnimationState();

    public WalkingFumeshroomEntity(EntityType<WalkingFumeshroomEntity> type, Level world) {
        super(type, world);
        this.xpReward = 1;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_has_item, (Object)false);
        builder.define(DATA_Grow, (Object)0);
        builder.define(DATA_grow_warrior, (Object)0);
        builder.define(DATA_grow_thrower, (Object)0);
        builder.define(DATA_twm_number, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.stem.hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.stem.break"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datahas_item", ((Boolean)this.entityData.get(DATA_has_item)).booleanValue());
        compound.putInt("DataGrow", ((Integer)this.entityData.get(DATA_Grow)).intValue());
        compound.putInt("Datagrow_warrior", ((Integer)this.entityData.get(DATA_grow_warrior)).intValue());
        compound.putInt("Datagrow_thrower", ((Integer)this.entityData.get(DATA_grow_thrower)).intValue());
        compound.putInt("Datatwm_number", ((Integer)this.entityData.get(DATA_twm_number)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datahas_item")) {
            this.entityData.set(DATA_has_item, (Object)compound.getBoolean("Datahas_item"));
        }
        if (compound.contains("DataGrow")) {
            this.entityData.set(DATA_Grow, (Object)compound.getInt("DataGrow"));
        }
        if (compound.contains("Datagrow_warrior")) {
            this.entityData.set(DATA_grow_warrior, (Object)compound.getInt("Datagrow_warrior"));
        }
        if (compound.contains("Datagrow_thrower")) {
            this.entityData.set(DATA_grow_thrower, (Object)compound.getInt("Datagrow_thrower"));
        }
        if (compound.contains("Datatwm_number")) {
            this.entityData.set(DATA_twm_number, (Object)compound.getInt("Datatwm_number"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        super.mobInteract(sourceentity, hand);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        WalkingFumeshroomEntity entity = this;
        Level world = this.level();
        return WalkingFumeshroomRightClickProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity, itemstack);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState2.animateWhen(WalkingFumeshroomAnimationHasItemProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        WalkingFumeshroomTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)RadiationZoneRebornModEntities.WALKING_FUMESHROOM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return WalkingFumeshroomSpawnProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.16);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 8.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

