/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.item;

import java.util.List;
import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModItems;
import net.mayoi.radiationzonereborn.procedures.DustormGreatswordSwingProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class DustormGreatswordItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 2000;
        }

        public float getSpeed() {
            return 8.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_NETHERITE_TOOL;
        }

        public int getEnchantmentValue() {
            return 18;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RadiationZoneRebornModItems.GIANTROCK_INGOT.get())});
        }
    };

    public DustormGreatswordItem() {
        super(TOOL_TIER, new Item.Properties().attributes(SwordItem.createAttributes((Tier)TOOL_TIER, (float)9.5f, (float)-3.0f)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.radiation_zone_reborn.dustorm_greatsword.description_0"));
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
        Player player;
        float attackStrength;
        boolean retval = super.onEntitySwing(itemstack, entity, hand);
        if (entity instanceof Player && (attackStrength = (player = (Player)entity).getAttackStrengthScale(0.0f)) >= 0.9f) {
            DustormGreatswordSwingProcedure.execute((LevelAccessor)entity.level(), (Entity)entity, itemstack);
        }
        return retval;
    }
}

