/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.item;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModItems;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class GiantrockArmorItem
extends ArmorItem {
    public static Holder<ArmorMaterial> ARMOR_MATERIAL = null;

    @SubscribeEvent
    public static void registerArmorMaterial(RegisterEvent event) {
        event.register(Registries.ARMOR_MATERIAL, registerHelper -> {
            ArmorMaterial armorMaterial = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
                map.put(ArmorItem.Type.BOOTS, 3);
                map.put(ArmorItem.Type.LEGGINGS, 7);
                map.put(ArmorItem.Type.CHESTPLATE, 8);
                map.put(ArmorItem.Type.HELMET, 3);
                map.put(ArmorItem.Type.BODY, 8);
            }), 12, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"item.armor.equip_iron")), () -> Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RadiationZoneRebornModItems.GIANTROCK_INGOT.get())}), List.of(new ArmorMaterial.Layer(ResourceLocation.parse((String)"radiation_zone_reborn:giantrock_armor"))), 2.5f, 0.1f);
            registerHelper.register(ResourceLocation.parse((String)"radiation_zone_reborn:giantrock_armor"), (Object)armorMaterial);
            ARMOR_MATERIAL = BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)armorMaterial);
        });
    }

    public GiantrockArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Boots
    extends GiantrockArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(35)));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            if (Screen.hasShiftDown()) {
                list.add((Component)Component.translatable((String)"item.radiation_zone_reborn.armor.description_all"));
                list.add((Component)Component.translatable((String)"item.radiation_zone_reborn.giantrock_armors.description_0"));
            } else {
                list.add((Component)Component.translatable((String)"item.radiation_zone_reborn.armor.description.shift"));
            }
        }
    }

    public static class Leggings
    extends GiantrockArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties().durability(ArmorItem.Type.LEGGINGS.getDurability(35)));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            if (Screen.hasShiftDown()) {
                list.add((Component)Component.translatable((String)"item.radiation_zone_reborn.armor.description_all"));
                list.add((Component)Component.translatable((String)"item.radiation_zone_reborn.giantrock_armors.description_0"));
            } else {
                list.add((Component)Component.translatable((String)"item.radiation_zone_reborn.armor.description.shift"));
            }
        }
    }

    public static class Chestplate
    extends GiantrockArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().durability(ArmorItem.Type.CHESTPLATE.getDurability(35)));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            if (Screen.hasShiftDown()) {
                list.add((Component)Component.translatable((String)"item.radiation_zone_reborn.armor.description_all"));
                list.add((Component)Component.translatable((String)"item.radiation_zone_reborn.giantrock_armors.description_0"));
            } else {
                list.add((Component)Component.translatable((String)"item.radiation_zone_reborn.armor.description.shift"));
            }
        }
    }

    public static class Helmet
    extends GiantrockArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties().durability(ArmorItem.Type.HELMET.getDurability(35)));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            if (Screen.hasShiftDown()) {
                list.add((Component)Component.translatable((String)"item.radiation_zone_reborn.armor.description_all"));
                list.add((Component)Component.translatable((String)"item.radiation_zone_reborn.giantrock_armors.description_0"));
            } else {
                list.add((Component)Component.translatable((String)"item.radiation_zone_reborn.armor.description.shift"));
            }
        }
    }
}

