/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.procedures;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class RadiationZonePortalInsideProcedure {
    public static void execute(LevelAccessor world, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.getPersistentData().getDouble("PortalCD") > 0.0) {
            return;
        }
        entity.getPersistentData().putDouble("IsPortal", 12.0);
        entity.getPersistentData().putDouble("PortalCD", 140.0);
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel currentLevel = (ServerLevel)world;
        ResourceKey currentDimension = currentLevel.dimension();
        ResourceKey targetKey = currentDimension == Level.OVERWORLD ? ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"radiation_zone_reborn:radiation_zone")) : Level.OVERWORLD;
        ServerLevel targetLevel = currentLevel.getServer().getLevel(targetKey);
        if (targetLevel == null || targetLevel == currentLevel) {
            return;
        }
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float yaw = entity.getYRot();
        float pitch = entity.getXRot();
        double targetX = entity.getX() + 1.0;
        double targetY = entity.getY() + 2.0;
        double targetZ = entity.getZ() + 1.0;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.teleportTo(targetLevel, x, y, z, yaw, pitch);
            entity.teleportTo(x + 1.0, y + 2.0, z + 1.0);
        } else {
            DimensionTransition transition = new DimensionTransition(targetLevel, new Vec3(x, y, z), Vec3.ZERO, yaw, pitch, DimensionTransition.DO_NOTHING);
            entity.changeDimension(transition);
            entity.teleportTo(x + 1.0, y + 2.0, z + 1.0);
        }
    }
}

