/*
 * Decompiled with CFR 0.152.
 */
package com.Nuaah.NHerbFlowerExtBox.block.entity;

import com.Nuaah.NHerbFlowerExtBox.block.entity.NHerbFlowerExtBoxEntityTypes;
import com.Nuaah.NHerbFlowerExtBox.gui.container.ClayCauldronMenu;
import com.Nuaah.NHerbFlowerExtBox.regi.ConstituentsData;
import com.Nuaah.NHerbFlowerExtBox.regi.ConstituentsJsonLoader;
import com.Nuaah.NHerbFlowerExtBox.regi.CustomPotionData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ClayCauldronEntity
extends BlockEntity
implements MenuProvider {
    final int MAX_WATER = 3;
    int waterAmount = 0;
    List<Float> waterColor = new ArrayList<Float>(Arrays.asList(Float.valueOf(0.2f), Float.valueOf(0.4f), Float.valueOf(1.0f), Float.valueOf(1.0f)));
    final int MAX_PROGRESS = 100;
    int progress = 0;
    int progressCounter = 0;
    boolean evaporate = false;
    boolean hasItem = false;
    String liquidType = "";
    Map<String, Float> constituents = new HashMap<String, Float>();
    Map<String, Integer> durations = new HashMap<String, Integer>();
    private final ItemStackHandler itemHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slotIndex) {
            super.onContentsChanged(slotIndex);
            for (int i = 0; i < ClayCauldronEntity.this.itemHandler.getSlots(); ++i) {
                if (!ClayCauldronEntity.this.itemHandler.getStackInSlot(i).m_41619_()) {
                    ClayCauldronEntity.this.hasItem = true;
                    break;
                }
                ClayCauldronEntity.this.hasItem = false;
            }
        }
    };
    private boolean heating = false;

    public ClayCauldronEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)NHerbFlowerExtBoxEntityTypes.CLAY_CAULDRON.get(), pos, state);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public void addWater(int amount) {
        this.waterAmount += amount;
        if (this.waterAmount >= 3) {
            this.waterAmount = 3;
        }
        if (this.waterAmount <= 0) {
            System.out.println("RESET");
            this.waterAmount = 0;
            this.liquidType = "";
            this.constituents.clear();
            this.durations.clear();
            this.waterColor.clear();
        }
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.f_58857_.m_151523_((BlockEntity)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addWater(int amount, String liquid) {
        if (this.waterAmount <= 0) {
            if (liquid.equals("water")) {
                this.waterColor = new ArrayList<Float>(Arrays.asList(Float.valueOf(0.2f), Float.valueOf(0.4f), Float.valueOf(1.0f), Float.valueOf(1.0f)));
            }
            if (liquid.equals("ethanol")) {
                this.waterColor = new ArrayList<Float>(Arrays.asList(Float.valueOf(0.4f), Float.valueOf(0.6f), Float.valueOf(1.0f), Float.valueOf(1.0f)));
            }
        }
        if (this.liquidType.equals(liquid) || this.liquidType.isEmpty()) {
            this.waterAmount += amount;
        }
        if (this.waterAmount >= 3) {
            this.waterAmount = 3;
        }
        if (this.waterAmount <= 0) {
            this.waterAmount = 0;
            this.liquidType = "";
        } else {
            this.liquidType = liquid;
        }
        if (amount > 0) {
            void var4_8;
            float calc;
            for (Map.Entry<String, Float> entry : this.constituents.entrySet()) {
                calc = entry.getValue().floatValue() * 0.6f;
                if ((double)calc < 0.1) {
                    this.constituents.remove(entry.getKey());
                    continue;
                }
                this.constituents.put(entry.getKey(), Float.valueOf(calc));
            }
            for (Map.Entry<String, Number> entry : this.durations.entrySet()) {
                calc = (float)((Integer)entry.getValue()).intValue() * 0.6f;
                this.durations.put(entry.getKey(), (int)calc);
            }
            ArrayList<Float> color = new ArrayList<Float>(Arrays.asList(Float.valueOf(0.2f), Float.valueOf(0.4f), Float.valueOf(1.0f), Float.valueOf(1.0f)));
            if (this.liquidType.equals("ethanol")) {
                color = new ArrayList<Float>(Arrays.asList(Float.valueOf(0.4f), Float.valueOf(0.6f), Float.valueOf(1.0f), Float.valueOf(1.0f)));
            }
            boolean bl = false;
            while (var4_8 < this.waterColor.size()) {
                calc = (this.waterColor.get((int)var4_8).floatValue() + ((Float)color.get((int)var4_8)).floatValue()) / 2.0f;
                if (calc > 1.0f) {
                    calc = 1.0f;
                }
                if (calc < 0.0f) {
                    calc = 0.0f;
                }
                this.waterColor.set((int)var4_8, Float.valueOf(calc));
                ++var4_8;
            }
        }
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int getWater() {
        return this.waterAmount;
    }

    public int getMaxWater() {
        return 3;
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean getHeating() {
        return this.heating;
    }

    public List<Float> getWaterColor() {
        return this.waterColor;
    }

    public Map getConstituents() {
        System.out.println(this.constituents);
        return this.constituents;
    }

    public Map getDurations() {
        System.out.println(this.durations);
        return this.durations;
    }

    public String getLiquidType() {
        return this.liquidType;
    }

    public void setHeating(boolean heat) {
        this.heating = heat;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean getEvaporate() {
        return this.evaporate;
    }

    public void switchEvaporate() {
        this.evaporate = !this.evaporate;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void tick() {
        if (this.heating && this.hasItem && this.waterAmount > 0) {
            ++this.progressCounter;
            if (this.progressCounter >= 2) {
                this.progressCounter = 0;
                if (this.progress >= 100) {
                    this.progress = 0;
                    this.consumePowder();
                } else {
                    ++this.progress;
                }
            }
        } else {
            this.progress = 0;
        }
    }

    private void mixingHerb(ItemStack stack) {
        String id = stack.m_41720_().toString();
        ConstituentsData data = ConstituentsJsonLoader.CONSTITUENTS_DATA.get(id);
        if (data != null) {
            for (ConstituentsData.ComponentData c : data.components) {
                String effect = c.id;
                String soluble = c.soluble;
                if (!soluble.equals("water") ? soluble.equals("fat") && !this.liquidType.equals("ethanol") : !this.liquidType.equals("water")) continue;
                if (this.constituents.get(effect) != null) {
                    float calc = this.constituents.get(effect).floatValue() + c.amount;
                    this.constituents.put(effect, Float.valueOf(calc));
                } else {
                    this.constituents.put(effect, Float.valueOf(c.amount));
                }
                if (this.durations.get(effect) != null) {
                    int calc = this.durations.get(effect) + c.duration;
                    this.durations.put(effect, calc);
                } else {
                    this.durations.put(effect, c.duration);
                }
                for (int i = 0; i < this.waterColor.size(); ++i) {
                    float calc = this.waterColor.get(i).floatValue() + data.color.get(i).floatValue();
                    if (calc > 1.0f) {
                        calc = 1.0f;
                    }
                    this.waterColor.set(i, Float.valueOf(calc));
                }
            }
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    private void addEffect(ItemStack stack, CustomPotionData data) {
        CompoundTag nbt = stack.m_41784_();
        ListTag list = nbt.m_128437_("CustomEffects", 10);
        list.add((Object)data.toTag());
        nbt.m_128365_("CustomEffects", (Tag)list);
    }

    private void consumePowder() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            this.mixingHerb(this.itemHandler.getStackInSlot(i));
            this.itemHandler.extractItem(i, 1, false);
            if (this.itemHandler.getStackInSlot(i).m_41613_() > 0) continue;
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.nherbflowerextbox.clay_cauldron");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("WaterAmount", this.waterAmount);
        nbt.m_128405_("Progress", this.progress);
        nbt.m_128379_("Heating", this.heating);
        nbt.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128359_("Liquid", this.liquidType);
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry<String, Float> entry : this.constituents.entrySet()) {
            mapTag.m_128350_(entry.getKey(), entry.getValue().floatValue());
        }
        System.out.println("CON");
        System.out.println(this.constituents);
        nbt.m_128365_("Constituents", (Tag)mapTag);
        CompoundTag mapTag2 = new CompoundTag();
        for (int i = 0; i < this.waterColor.size(); ++i) {
            mapTag2.m_128350_("WaterColor" + i, this.waterColor.get(i).floatValue());
        }
        System.out.println("WATER");
        System.out.println(this.waterColor);
        nbt.m_128365_("WaterColors", (Tag)mapTag2);
        CompoundTag mapTag3 = new CompoundTag();
        for (Map.Entry<String, Integer> entry : this.durations.entrySet()) {
            mapTag3.m_128405_(entry.getKey(), entry.getValue().intValue());
        }
        nbt.m_128365_("Durations", (Tag)mapTag3);
        System.out.println(nbt.m_128469_("Constituents"));
        System.out.println(nbt.m_128469_("Durations"));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        System.out.println("LOAD");
        this.waterAmount = nbt.m_128451_("WaterAmount");
        this.progress = nbt.m_128451_("Progress");
        this.heating = nbt.m_128471_("Heating");
        this.itemHandler.deserializeNBT(nbt.m_128469_("Items"));
        this.liquidType = nbt.m_128461_("Liquid");
        this.constituents.clear();
        CompoundTag mapTag = nbt.m_128469_("Constituents");
        for (String key : mapTag.m_128431_()) {
            this.constituents.put(key, Float.valueOf(mapTag.m_128457_(key)));
        }
        CompoundTag mapTag2 = nbt.m_128469_("WaterColors");
        for (int i = 0; i < this.waterColor.size(); ++i) {
            this.waterColor.set(i, Float.valueOf(mapTag2.m_128457_("WaterColor" + i)));
        }
        this.durations.clear();
        CompoundTag mapTag3 = nbt.m_128469_("Durations");
        for (String key : mapTag3.m_128431_()) {
            this.durations.put(key, mapTag3.m_128451_(key));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int a, Inventory inventory, Player player) {
        return new ClayCauldronMenu(a, inventory, this);
    }
}

