/*
 * Decompiled with CFR 0.152.
 */
package com.Nuaah.NHerbFlowerExtBox.regi.shader;

import com.Nuaah.NHerbFlowerExtBox.mixin.PostChainMixin;
import com.Nuaah.NHerbFlowerExtBox.regi.NHerbFlowerExtBoxEffect;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.Uniform;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nherbflowerextbox", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RainbowVisionShaderManager {
    private static PostChain shaderChain;
    public static final ResourceLocation SHADER_LOC;
    private static int lastWidth;
    private static int lastHeight;

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        if (mc.f_91074_.m_21023_((MobEffect)NHerbFlowerExtBoxEffect.RAINBOW_VISION.get())) {
            RainbowVisionShaderManager.renderShader(mc, event.getPartialTick());
        } else {
            RainbowVisionShaderManager.cleanup();
        }
    }

    private static void renderShader(Minecraft mc, float partialTicks) {
        if (shaderChain == null || mc.m_91268_().m_85441_() != lastWidth || mc.m_91268_().m_85442_() != lastHeight) {
            RainbowVisionShaderManager.loadShader(mc);
        }
        if (shaderChain != null) {
            try {
                RainbowVisionShaderManager.updateUniforms(mc, partialTicks);
                shaderChain.m_110023_(partialTicks);
                mc.m_91385_().m_83947_(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                RainbowVisionShaderManager.cleanup();
            }
        }
    }

    private static void loadShader(Minecraft mc) {
        RainbowVisionShaderManager.cleanup();
        try {
            shaderChain = new PostChain(mc.m_91097_(), mc.m_91098_(), mc.m_91385_(), SHADER_LOC);
            shaderChain.m_110025_(mc.m_91268_().m_85441_(), mc.m_91268_().m_85442_());
            lastWidth = mc.m_91268_().m_85441_();
            lastHeight = mc.m_91268_().m_85442_();
        }
        catch (IOException e) {
            shaderChain = null;
        }
    }

    private static void updateUniforms(Minecraft mc, float partialTicks) {
        if (shaderChain == null) {
            return;
        }
        PostChainMixin accessor = (PostChainMixin)shaderChain;
        List<PostPass> passes = accessor.getPasses();
        if (passes.isEmpty()) {
            return;
        }
        PostPass shaderPass = passes.get(0);
        Uniform timeUniform = shaderPass.m_110074_().m_108952_("u_Time");
        if (timeUniform != null) {
            int programId = shaderPass.m_110074_().m_108943_();
            GlStateManager._glUseProgram((int)programId);
            float time = ((float)mc.f_91073_.m_46467_() + partialTicks) * 0.05f;
            timeUniform.m_5985_(time);
            timeUniform.m_85633_();
            GlStateManager._glUseProgram((int)0);
        }
    }

    private static void cleanup() {
        if (shaderChain != null) {
            shaderChain.close();
            shaderChain = null;
        }
        lastWidth = 0;
        lastHeight = 0;
    }

    static {
        SHADER_LOC = new ResourceLocation("nherbflowerextbox", "shaders/post/rainbow_vision.json");
        lastWidth = 0;
        lastHeight = 0;
    }
}

