/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.tdmweaponsreforged.common.init;

import com.ombremoon.tdmweaponsreforged.common.init.MobEffectInit;
import com.ombremoon.tdmweaponsreforged.common.object.item.BloodthirsterItem;
import com.ombremoon.tdmweaponsreforged.common.object.item.DeathSpoonItem;
import com.ombremoon.tdmweaponsreforged.common.object.item.DebugItem;
import com.ombremoon.tdmweaponsreforged.common.object.item.GlassRapierItem;
import com.ombremoon.tdmweaponsreforged.common.object.item.HastenedWeaponItem;
import com.ombremoon.tdmweaponsreforged.common.object.item.HeatWeaponItem;
import com.ombremoon.tdmweaponsreforged.common.object.item.LightHammerItem;
import com.ombremoon.tdmweaponsreforged.common.object.item.MagnetHammerItem;
import com.ombremoon.tdmweaponsreforged.common.object.item.RuinedZweihanderItem;
import com.ombremoon.tdmweaponsreforged.common.object.item.TDMPickaxeItem;
import com.ombremoon.tdmweaponsreforged.common.object.item.TDMWeaponItem;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ItemInit {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tdmweaponsreforged");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"tdmweaponsreforged");
    public static final Predicate<LivingEntity> SAKURA = livingEntity -> {
        Optional key = livingEntity.m_9236_().m_204166_(livingEntity.m_20097_()).m_203543_();
        return key.filter(biomeResourceKey -> biomeResourceKey == Biomes.f_271432_).isPresent();
    };
    public static final Predicate<LivingEntity> TEMPEST = livingEntity -> livingEntity.m_20186_() >= 100.0 || livingEntity.m_9236_().m_46471_();
    public static final RegistryObject<TDMWeaponItem> BREAKER_BLADE = ItemInit.registerWeapon("breaker_blade", 0, 24.0f, -3.0f);
    public static final RegistryObject<TDMWeaponItem> DEBUG_STICK = ItemInit.registerWeapon("debugstick", () -> new DebugItem(999999.0f, 0.0f));
    public static final RegistryObject<TDMWeaponItem> DOUBLE_WARAXE = ItemInit.registerWeapon("double_waraxe", 500, 9.0f, -3.0f);
    public static final RegistryObject<TDMWeaponItem> DRAGONFANG_GLAIVE = ItemInit.registerWeapon("dragonfang_glaive", 2031, 7.0f, -2.2f);
    public static final RegistryObject<TDMWeaponItem> EGYPTIAN_FAN_AXE = ItemInit.registerWeapon("egyptian_fan_axe", 250, 6.0f, -2.4f);
    public static final RegistryObject<TDMWeaponItem> FANGED_KATANA = ItemInit.registerWeapon("fanged_katana", 1561, 8.0f, -2.4f);
    public static final RegistryObject<TDMWeaponItem> FLAYER_SPEAR = ItemInit.registerWeapon("flayer_spear", 500, 6.0f, -2.4f);
    public static final RegistryObject<TDMWeaponItem> GILDED_GREATHAMMER = ItemInit.registerWeapon("gilded_greathammer", 939, 2.0f, -3.0f);
    public static final RegistryObject<TDMWeaponItem> GLASS_RAPIER = ItemInit.registerWeapon("glass_rapier", () -> new GlassRapierItem(5.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> GOLDEN_SPATULA = ItemInit.registerWeapon("golden_spatula", 4057, 1.0f, 4.0f);
    public static final RegistryObject<TDMWeaponItem> GOLDEN_TRIDENT = ItemInit.registerWeapon("golden_trident", 500, 8.0f, -2.7f);
    public static final RegistryObject<TDMWeaponItem> LIGHT_HAMMER = ItemInit.registerWeapon("hammer_of_light", () -> new LightHammerItem(15.0f, -3.0f));
    public static final RegistryObject<TDMWeaponItem> HEAVY_STAFF_CLEAVER = ItemInit.registerWeapon("heavy_staff_cleaver", 1561, 2.0f, -3.0f);
    public static final RegistryObject<TDMWeaponItem> ICE_HAMMER = ItemInit.registerWeapon("ice_hammer", 2031, 9.0f, -3.0f);
    public static final RegistryObject<TDMWeaponItem> JADE_HAMMER = ItemInit.registerWeapon("jade_hammer", 939, 9.0f, -3.0f);
    public static final RegistryObject<TDMWeaponItem> LUNAR_CRESCENT_DAGGER = ItemInit.registerWeapon("lunar_crescent_dagger", 939, 7.0f, -2.2f);
    public static final RegistryObject<TDMWeaponItem> MAGNET_HAMMER = ItemInit.registerWeapon("magnet_hammer", () -> new MagnetHammerItem(9.0f, -3.0f));
    public static final RegistryObject<TDMWeaponItem> MOLTEN_OBSIDIAN_HAMMER = ItemInit.registerWeapon("molten_obsidian_hammer", () -> new HeatWeaponItem(1561, 9.0f, -3.0f, 4, "tdmweaponsreforged.obsidian_hammer.tooltip"));
    public static final RegistryObject<TDMWeaponItem> RUINED_ZWEIHANDER = ItemInit.registerWeapon("ruined_zweihander", () -> new RuinedZweihanderItem(10.0f, -2.5f));
    public static final RegistryObject<TDMWeaponItem> SAKURA_GHOSTKATANA = ItemInit.registerWeapon("sakura_ghostkatana", () -> new HastenedWeaponItem(2031, 7.0f, -2.0f, (Supplier<MobEffect>)MobEffectInit.SAKURA_BLESSING, SAKURA, "tdmweaponsreforged.sakura_katana.tooltip", ChatFormatting.LIGHT_PURPLE));
    public static final RegistryObject<TDMWeaponItem> SHADOWFANG_BLADE = ItemInit.registerWeapon("shadowfang_blade", 1561, 7.0f, -2.4f);
    public static final RegistryObject<TDMWeaponItem> SOLAR_SPEAR = ItemInit.registerWeapon("solar_spear", () -> new HeatWeaponItem(939, 11.0f, -2.8f, 3, "tdmweaponsreforged.solar_spear.tooltip"));
    public static final RegistryObject<TDMWeaponItem> SPOON_OF_DEATH = ItemInit.registerWeapon("spoon_of_death", () -> new DeathSpoonItem(3.0f, -2.7f));
    public static final RegistryObject<TDMWeaponItem> TEMPEST_SCIMITAR = ItemInit.registerWeapon("tempest_scimitar", () -> new HastenedWeaponItem(1561, 4.0f, -2.4f, (Supplier<MobEffect>)MobEffectInit.TEMPEST_GRACE, TEMPEST, "tdmweaponsreforged.tempest_scimitar.tooltip", ChatFormatting.AQUA));
    public static final RegistryObject<TDMWeaponItem> THE_BLOODTHIRSTER = ItemInit.registerWeapon("the_bloodthirster", () -> new BloodthirsterItem(9.0f, -2.7f));
    public static final RegistryObject<TDMWeaponItem> KATANA = ItemInit.registerWeapon("katana", () -> new TDMWeaponItem(2031, 7.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> THE_PICKAXE = ItemInit.registerWeapon("the_pickaxe", () -> new TDMPickaxeItem(939, 4.0f, -2.2f));
    public static final RegistryObject<Item> WEAPON_TEMPLATE = ITEMS.register("weapon_template", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> SHATTERED_RAPIER = ITEMS.register("shattered_rapier", () -> new Item(new Item.Properties()));
    public static final RegistryObject<TDMWeaponItem> ANCHOR = ItemInit.registerWeapon("anchor", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> AXE = ItemInit.registerWeapon("axe", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> BATTLE_STAFF = ItemInit.registerWeapon("battle_staff", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> CLAW = ItemInit.registerWeapon("claw", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> CLAYMORE = ItemInit.registerWeapon("claymore", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> CORAL_BLADE = ItemInit.registerWeapon("coral_blade", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> CUTLASS = ItemInit.registerWeapon("cutlass", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> DAGGER = ItemInit.registerWeapon("dagger", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> DOUBLE_AXE = ItemInit.registerWeapon("double_axe", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> FIST = ItemInit.registerWeapon("fist", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> GLAIVE = ItemInit.registerWeapon("glaive", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> HALBERD = ItemInit.registerWeapon("halberd", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> HAMMER = ItemInit.registerWeapon("hammer", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> HEAVY_AXE = ItemInit.registerWeapon("heavy_axe", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> DEBUG_KATANA = ItemInit.registerWeapon("debug_katana", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> LANCE = ItemInit.registerWeapon("lance", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> MACE = ItemInit.registerWeapon("mace", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> PICKAXE = ItemInit.registerWeapon("debug_pickaxe", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> RAPIER = ItemInit.registerWeapon("rapier", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> SCYTHE = ItemInit.registerWeapon("scythe", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> SICKLE = ItemInit.registerWeapon("sickle", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> SOUL_KNIFE = ItemInit.registerWeapon("soul_knife", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> SPEAR = ItemInit.registerWeapon("spear", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> STAFF = ItemInit.registerWeapon("staff", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> SWORD = ItemInit.registerWeapon("sword", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> TRIDENT = ItemInit.registerWeapon("trident", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> TWIN_BLADE = ItemInit.registerWeapon("twin_blade", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<TDMWeaponItem> WAND = ItemInit.registerWeapon("wand", () -> new DebugItem(999.0f, -2.0f));
    public static final RegistryObject<CreativeModeTab> TAB = ItemInit.registerCreativeModeTab("tdmweaponsreforged", SAKURA_GHOSTKATANA);

    protected static RegistryObject<TDMWeaponItem> registerWeapon(String name, int durability, float attackDamage, float attackSpeed) {
        return ITEMS.register(name, () -> new TDMWeaponItem(durability, attackDamage, attackSpeed));
    }

    protected static RegistryObject<TDMWeaponItem> registerWeapon(String name, Supplier<TDMWeaponItem> item) {
        return ITEMS.register(name, item);
    }

    protected static RegistryObject<CreativeModeTab> registerCreativeModeTab(String name, RegistryObject<TDMWeaponItem> item) {
        return CREATIVE_MODE_TABS.register(name, () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)item.get())).m_257941_((Component)Component.m_237115_((String)("itemgroup." + name + ".tab"))).m_257501_((itemDisplayParameters, output) -> {
            for (RegistryObject object : ITEMS.getEntries()) {
                ItemStack stack = new ItemStack((ItemLike)object.get());
                output.m_246342_(stack);
            }
        }).m_257652_());
    }

    public static void register(IEventBus modEventBus) {
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
    }
}

