/*
 * Decompiled with CFR 0.152.
 */
package space.bbkr.aquarius;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2597;
import net.minecraft.class_2680;
import net.minecraft.class_3000;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import space.bbkr.aquarius.Aquarius;

public class ChorusConduitBlockEntity
extends class_2597
implements class_3000 {
    private final List<class_2338> purpurPositions = Lists.newArrayList();
    private boolean active;
    private float ticksActive;
    private boolean eyeOpen;
    private class_1309 target;
    private UUID targetUuid;
    private long nextSoundTime;

    public ChorusConduitBlockEntity() {
        this(Aquarius.CHORUS_CONDUIT_BE);
    }

    public ChorusConduitBlockEntity(class_2591<?> type) {
        super(type);
    }

    public void method_16896() {
        ++this.field_11936;
        long time = this.field_11863.method_8510();
        if (time % 40L == 0L) {
            this.setActive(this.shouldBeActive());
            if (!this.field_11863.field_9236 && this.method_11065()) {
                this.addEffectsToPlayers();
            }
        }
        if (time % 80L == 0L && this.method_11065()) {
            this.method_11067(class_3417.field_14632);
        }
        if (time > this.nextSoundTime && this.method_11065()) {
            this.nextSoundTime = time + 60L + (long)this.field_11863.method_8409().nextInt(40);
            this.method_11067(class_3417.field_15071);
        }
        if (this.field_11863.field_9236) {
            this.updateClientTarget();
            this.spawnParticles();
            if (this.method_11065()) {
                this.ticksActive += 1.0f;
            }
        }
    }

    private boolean shouldBeActive() {
        this.purpurPositions.clear();
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int yOffset = -2; yOffset <= 2; ++yOffset) {
                for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                    class_2338 pos;
                    class_2680 state;
                    int xAbs = Math.abs(xOffset);
                    int yAbs = Math.abs(yOffset);
                    int zAbs = Math.abs(zOffset);
                    if ((xOffset != 0 || yAbs != 2 && zAbs != 2) && (yOffset != 0 || xAbs != 2 && zAbs != 2) && (zOffset != 0 || xAbs != 2 && yAbs != 2) || !Aquarius.CHORUS_CONDUIT_ACTIVATORS.method_15141((Object)(state = this.field_11863.method_8320(pos = this.field_11867.method_10069(xOffset, yOffset, zOffset))).method_26204())) continue;
                    this.purpurPositions.add(pos);
                }
            }
        }
        this.setEyeOpen(this.purpurPositions.size() >= 42);
        return this.purpurPositions.size() >= 16;
    }

    private void addEffectsToPlayers() {
        int posZ;
        int posY;
        int listSize = this.purpurPositions.size();
        int range = listSize / 7 * 16;
        int posX = this.field_11867.method_10263();
        class_238 aabb = new class_238((double)posX, (double)(posY = this.field_11867.method_10264()), (double)(posZ = this.field_11867.method_10260()), (double)(posX + 1), (double)(posY + 1), (double)(posZ + 1)).method_1014((double)range).method_1009(0.0, (double)this.field_11863.method_8322(), 0.0);
        List players = this.field_11863.method_8390(class_1657.class, aabb, null);
        if (!players.isEmpty()) {
            for (class_1657 player : players) {
                class_243 position = new class_243((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
                if (!(position.method_1022(player.method_19538()) <= (double)range)) continue;
                player.method_6092(new class_1293(Aquarius.ATLANTEAN, 260, 0, true, true));
            }
        }
    }

    private void updateClientTarget() {
        if (this.targetUuid == null) {
            this.target = null;
        } else if (this.target == null || !this.target.method_5667().equals(this.targetUuid)) {
            this.target = this.findExistingTarget();
            if (this.target == null) {
                this.targetUuid = null;
            }
        }
    }

    private class_238 getAreaOfEffect() {
        int posX = this.field_11867.method_10263();
        int posY = this.field_11867.method_10264();
        int posZ = this.field_11867.method_10260();
        return new class_238((double)posX, (double)posX, (double)posZ, (double)(posX + 1), (double)(posY + 1), (double)(posZ + 1)).method_1014(8.0);
    }

    private class_1309 findExistingTarget() {
        List entities = this.field_11863.method_8390(class_1309.class, this.getAreaOfEffect(), entity -> entity.method_5667().equals(this.targetUuid));
        return entities.size() == 1 ? (class_1309)entities.get(0) : null;
    }

    private void spawnParticles() {
        float distY;
        float distX;
        Random rand = this.field_11863.field_9229;
        float rot = class_3532.method_15374((float)((float)(this.field_11936 + 35) * 0.1f)) / 2.0f + 0.5f;
        rot = (rot * rot + rot) * 0.3f;
        class_243 vec = new class_243((double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 1.5f + rot), (double)((float)this.field_11867.method_10260() + 0.5f));
        for (class_2338 pos : this.purpurPositions) {
            if (rand.nextInt(50) != 0) continue;
            distX = -0.5f + rand.nextFloat();
            distY = -2.0f + rand.nextFloat();
            float distZ = -0.5f + rand.nextFloat();
            class_2338 relPos = pos.method_10059((class_2382)this.field_11867);
            class_243 particlePos = new class_243((double)distX, (double)distY, (double)distZ).method_1031((double)relPos.method_10263(), (double)relPos.method_10264(), (double)relPos.method_10260());
            this.field_11863.method_8406((class_2394)class_2398.field_11229, vec.field_1352, vec.field_1351, vec.field_1350, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350);
        }
        if (this.target != null) {
            class_243 playerEyes = new class_243(this.target.method_23317(), this.target.method_23318() + (double)this.target.method_18381(this.target.method_18376()), this.target.method_23321());
            float randVel = (-0.5f + rand.nextFloat()) * (3.0f + this.target.method_17681());
            distX = -1.0f + rand.nextFloat() * this.target.method_17682();
            distY = (-0.5f + rand.nextFloat()) * (3.0f + this.target.method_17681());
            class_243 velocity = new class_243((double)randVel, (double)distX, (double)distY);
            this.field_11863.method_8406((class_2394)class_2398.field_11229, playerEyes.field_1352, playerEyes.field_1351, playerEyes.field_1350, velocity.field_1352, velocity.field_1351, velocity.field_1350);
        }
    }

    public boolean method_11065() {
        return this.active;
    }

    public boolean method_11066() {
        return this.eyeOpen;
    }

    private void setActive(boolean active) {
        if (active != this.active) {
            this.method_11067(active ? class_3417.field_14700 : class_3417.field_14979);
        }
        this.active = active;
    }

    private void setEyeOpen(boolean open) {
        this.eyeOpen = open;
    }

    @Environment(value=EnvType.CLIENT)
    public float method_11061(float tickDelta) {
        return (this.ticksActive + tickDelta) * -0.0375f;
    }
}

