/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.venturecraft.gliders.common.compat.trinket.CuriosTrinketsUtil;
import net.venturecraft.gliders.common.item.GliderItem;
import net.venturecraft.gliders.common.sound.SoundRegistry;
import net.venturecraft.gliders.data.GliderData;
import net.venturecraft.gliders.network.MessagePOV;
import net.venturecraft.gliders.util.VCGliderTags;
import net.venturecraft.gliders.util.forge.GliderUtilImpl;

public class GliderUtil {
    public static boolean hasGliderEquipped(LivingEntity livingEntity) {
        return CuriosTrinketsUtil.getInstance().getFirstFoundGlider(livingEntity).m_41720_() instanceof GliderItem;
    }

    public static boolean isGliderActive(LivingEntity livingEntity) {
        ItemStack glider = CuriosTrinketsUtil.getInstance().getFirstFoundGlider(livingEntity);
        if (glider == null) {
            return false;
        }
        if (glider.m_41720_() instanceof GliderItem) {
            return GliderItem.isGlidingEnabled(glider);
        }
        return false;
    }

    public static boolean canDeployHere(LivingEntity livingEntity) {
        if (livingEntity.m_20159_()) {
            return false;
        }
        boolean isAir = !livingEntity.m_20096_() && livingEntity.m_9236_().m_8055_(livingEntity.m_20183_().m_6625_(2)).m_60795_() && livingEntity.m_9236_().m_8055_(livingEntity.m_20183_().m_7495_()).m_60795_();
        boolean updraftAround = GliderUtil.nearUpdraft(livingEntity);
        boolean isUpdraft = livingEntity.m_9236_().m_8055_(livingEntity.m_20183_().m_7495_()).m_204336_(VCGliderTags.UPDRAFT_BLOCKS);
        return isUpdraft || isAir || updraftAround || livingEntity.f_19789_ > 2.0f || GliderUtil.isGliderActive(livingEntity);
    }

    public static boolean nearUpdraft(LivingEntity livingEntity) {
        Iterator iterator = BlockPos.m_121985_((BlockPos)livingEntity.m_20183_(), (int)2, (int)3, (int)2).iterator();
        while (iterator.hasNext()) {
            BlockState above;
            BlockPos pos = (BlockPos)iterator.next();
            BlockState blockState = livingEntity.m_9236_().m_8055_(pos);
            if (!blockState.m_204336_(VCGliderTags.UPDRAFT_BLOCKS) || !(above = livingEntity.m_9236_().m_8055_(pos.m_7494_())).m_60795_() && above.m_280296_()) continue;
            if (blockState.m_61138_((Property)BlockStateProperties.f_61443_)) {
                return (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_);
            }
            return true;
        }
        return false;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceLocation getItemId(Item item) {
        return GliderUtilImpl.getItemId(item);
    }

    public static void onTickPlayerGlide(Level level, LivingEntity player) {
        ItemStack glider = CuriosTrinketsUtil.getInstance().getFirstFoundGlider(player);
        boolean playerCanGlide = !GliderUtil.isFlyingBlocked(player);
        boolean gliderCanGlide = GliderItem.isGlidingEnabled(glider);
        if (player instanceof Player) {
            Player player1 = (Player)player;
            boolean bl = playerCanGlide = playerCanGlide && !player1.m_150110_().f_35935_;
        }
        if (playerCanGlide && gliderCanGlide) {
            player.m_183634_();
            Vec3 m = player.m_20184_();
            boolean hasSpeedMods = GliderItem.hasCopperUpgrade(glider) && GliderItem.hasBeenStruck(glider);
            GliderUtil.lightningLogic(level, player, glider);
            if (player.f_19797_ % (player.m_9236_().m_46472_() == Level.f_46429_ ? 40 : 100) == 0 && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                int damageAmount = player.m_9236_().m_46472_() == Level.f_46429_ && !GliderItem.hasNetherUpgrade(glider) ? glider.m_41776_() / 2 : 1;
                glider.m_41721_(glider.m_41773_() + damageAmount);
                if (glider.m_41773_() >= glider.m_41776_()) {
                    level.m_6263_(null, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.4f + 1.2f));
                    GliderItem.setBroken(glider, true);
                    if (player.m_9236_().m_46472_() != Level.f_46429_) {
                        glider.m_41764_(0);
                    }
                }
            }
            GliderUtil.handleNetherLogic(level, player, glider);
            if (GliderUtil.checkUpdraft(level, player)) {
                return;
            }
            float horizonalSpeed = (float)player.m_20184_().m_165924_();
            if (horizonalSpeed >= 0.01f) {
                if (GliderItem.isSpaceGlider(glider)) {
                    for (int i = 0; i < 2; ++i) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123799_, player.m_20208_(0.5), player.m_20186_() + 2.5, player.m_20262_(0.5), 1.0, 0.0, 0.0);
                    }
                }
                if (hasSpeedMods) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123771_, player.m_20208_(0.5), player.m_20186_() + 2.5, player.m_20262_(0.5), 0.5, 0.0, 0.0);
                }
            }
            if (m.f_82480_ < -0.05) {
                player.m_20256_(new Vec3(m.f_82479_, -0.05, m.f_82481_));
            }
            return;
        }
        if (GliderUtil.isFlyingBlocked(player)) {
            GliderItem.setGlide(glider, false);
            GliderItem.setStruck(glider, false);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                new MessagePOV("").send(serverPlayer);
            }
        }
    }

    private static void handleNetherLogic(Level level, LivingEntity player, ItemStack glider) {
        if (level.m_46472_() == Level.f_46429_ && !GliderItem.hasNetherUpgrade(glider) && player.m_9236_().f_46441_.m_188503_(24) == 0 && !player.m_20067_()) {
            player.m_9236_().m_7785_(player.m_20185_() + 0.5, player.m_20186_() + 0.5, player.m_20189_() + 0.5, SoundEvents.f_11702_, player.m_5720_(), 1.0f + level.f_46441_.m_188501_(), level.f_46441_.m_188501_() * 0.7f + 0.3f, false);
            for (int i = 0; i < 2; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, player.m_20208_(0.5), player.m_20186_() + 2.5, player.m_20262_(0.5), 0.2, 1.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, player.m_20208_(0.5), player.m_20186_() + 2.5, player.m_20262_(0.5), 0.0, 0.2, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, player.m_20208_(0.5), player.m_20186_() + 2.5, player.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    private static void lightningLogic(Level level, LivingEntity player, ItemStack glider) {
        if (level.m_46758_(player.m_20183_())) {
            GliderData.get(player).ifPresent(gliderData -> {
                gliderData.setLightningTimer(gliderData.lightningTimer() + 1);
                if (gliderData.lightningTimer() == 1) {
                    player.m_216990_((SoundEvent)SoundRegistry.INCOMING_LIGHTNING.get());
                }
                if (player.m_9236_().f_46441_.m_188503_(24) == 0 && gliderData.lightningTimer() > 200 && !GliderItem.hasBeenStruck(glider)) {
                    LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, level);
                    lightningBolt.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                    lightningBolt.m_20874_(false);
                    level.m_7967_((Entity)lightningBolt);
                }
            });
            if (player.m_9236_().f_46441_.m_188503_(24) == 0 && !GliderItem.hasCopperUpgrade(glider)) {
                for (int i = 0; i < 2; ++i) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_175828_, player.m_20208_(0.5), player.m_20186_() + 2.5, player.m_20262_(0.5), 0.2, 1.0, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_175829_, player.m_20208_(0.5), player.m_20186_() + 2.5, player.m_20262_(0.5), 0.0, 0.2, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123785_, player.m_20208_(0.5), player.m_20186_() + 2.5, player.m_20262_(0.5), 0.0, 0.0, 0.0);
                }
            }
        } else {
            GliderData.get(player).ifPresent(gliderData -> gliderData.setLightningTimer(0));
        }
    }

    public static boolean checkUpdraft(Level world, LivingEntity player) {
        AABB boundingBox = player.m_20191_().m_82310_(2.0, 20.0, 2.0);
        List blocks = world.m_46847_(boundingBox).toList();
        Stream<BlockState> filteredBlocks = blocks.stream().filter(blockState -> blockState.m_204336_(VCGliderTags.UPDRAFT_BLOCKS) && GliderUtil.checkLit(blockState));
        if (filteredBlocks.toList().size() > 0 || GliderUtil.nearUpdraft(player)) {
            player.m_20334_(0.0, 0.5, 0.0);
            return true;
        }
        return false;
    }

    private static boolean checkLit(BlockState blockState) {
        if (blockState.m_61138_((Property)BlockStateProperties.f_61443_)) {
            return (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_);
        }
        return true;
    }

    public static boolean isFlyingBlocked(LivingEntity livingEntity) {
        return livingEntity.m_20096_() || livingEntity.m_20069_() || livingEntity.m_5842_() || livingEntity.m_6069_() || livingEntity.m_21255_();
    }

    public static boolean isGlidingWithActiveGlider(LivingEntity livingEntity) {
        return GliderUtil.hasGliderEquipped(livingEntity) && GliderUtil.isGliderActive(livingEntity) && !livingEntity.m_20096_() && !livingEntity.m_20069_();
    }
}

