/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.venturecraft.gliders.common.compat.trinket.CuriosTrinketsUtil;
import net.venturecraft.gliders.common.item.GliderItem;
import net.venturecraft.gliders.common.sound.SoundRegistry;
import net.venturecraft.gliders.data.GliderData;
import net.venturecraft.gliders.network.MessagePOV;
import net.venturecraft.gliders.util.VCGliderTags;
import net.venturecraft.gliders.util.fabric.GliderUtilImpl;

public class GliderUtil {
    public static boolean hasGliderEquipped(class_1309 livingEntity) {
        return CuriosTrinketsUtil.getInstance().getFirstFoundGlider(livingEntity).method_7909() instanceof GliderItem;
    }

    public static boolean isGliderActive(class_1309 livingEntity) {
        class_1799 glider = CuriosTrinketsUtil.getInstance().getFirstFoundGlider(livingEntity);
        if (glider == null) {
            return false;
        }
        if (glider.method_7909() instanceof GliderItem) {
            return GliderItem.isGlidingEnabled(glider);
        }
        return false;
    }

    public static boolean canDeployHere(class_1309 livingEntity) {
        if (livingEntity.method_5765()) {
            return false;
        }
        boolean isAir = !livingEntity.method_24828() && livingEntity.method_37908().method_8320(livingEntity.method_24515().method_10087(2)).method_26215() && livingEntity.method_37908().method_8320(livingEntity.method_24515().method_10074()).method_26215();
        boolean updraftAround = GliderUtil.nearUpdraft(livingEntity);
        boolean isUpdraft = livingEntity.method_37908().method_8320(livingEntity.method_24515().method_10074()).method_26164(VCGliderTags.UPDRAFT_BLOCKS);
        return isUpdraft || isAir || updraftAround || livingEntity.field_6017 > 2.0f || GliderUtil.isGliderActive(livingEntity);
    }

    public static boolean nearUpdraft(class_1309 livingEntity) {
        Iterator iterator = class_2338.method_25998((class_2338)livingEntity.method_24515(), (int)2, (int)3, (int)2).iterator();
        while (iterator.hasNext()) {
            class_2680 above;
            class_2338 pos = (class_2338)iterator.next();
            class_2680 blockState = livingEntity.method_37908().method_8320(pos);
            if (!blockState.method_26164(VCGliderTags.UPDRAFT_BLOCKS) || !(above = livingEntity.method_37908().method_8320(pos.method_10084())).method_26215() && above.method_51367()) continue;
            if (blockState.method_28498((class_2769)class_2741.field_12548)) {
                return (Boolean)blockState.method_11654((class_2769)class_2741.field_12548);
            }
            return true;
        }
        return false;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2960 getItemId(class_1792 item) {
        return GliderUtilImpl.getItemId(item);
    }

    public static void onTickPlayerGlide(class_1937 level, class_1309 player) {
        class_1799 glider = CuriosTrinketsUtil.getInstance().getFirstFoundGlider(player);
        boolean playerCanGlide = !GliderUtil.isFlyingBlocked(player);
        boolean gliderCanGlide = GliderItem.isGlidingEnabled(glider);
        if (player instanceof class_1657) {
            class_1657 player1 = (class_1657)player;
            boolean bl = playerCanGlide = playerCanGlide && !player1.method_31549().field_7479;
        }
        if (playerCanGlide && gliderCanGlide) {
            player.method_38785();
            class_243 m = player.method_18798();
            boolean hasSpeedMods = GliderItem.hasCopperUpgrade(glider) && GliderItem.hasBeenStruck(glider);
            GliderUtil.lightningLogic(level, player, glider);
            if (player.field_6012 % (player.method_37908().method_27983() == class_1937.field_25180 ? 40 : 100) == 0 && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                int damageAmount = player.method_37908().method_27983() == class_1937.field_25180 && !GliderItem.hasNetherUpgrade(glider) ? glider.method_7936() / 2 : 1;
                glider.method_7974(glider.method_7919() + damageAmount);
                if (glider.method_7919() >= glider.method_7936()) {
                    level.method_43128(null, serverPlayer.method_23317(), serverPlayer.method_23318(), serverPlayer.method_23321(), class_3417.field_15102, class_3419.field_15248, 1.0f, 1.0f / (level.method_8409().method_43057() * 0.4f + 1.2f));
                    GliderItem.setBroken(glider, true);
                    if (player.method_37908().method_27983() != class_1937.field_25180) {
                        glider.method_7939(0);
                    }
                }
            }
            GliderUtil.handleNetherLogic(level, player, glider);
            if (GliderUtil.checkUpdraft(level, player)) {
                return;
            }
            float horizonalSpeed = (float)player.method_18798().method_37267();
            if (horizonalSpeed >= 0.01f) {
                if (GliderItem.isSpaceGlider(glider)) {
                    for (int i = 0; i < 2; ++i) {
                        level.method_8406((class_2394)class_2398.field_11216, player.method_23322(0.5), player.method_23318() + 2.5, player.method_23325(0.5), 1.0, 0.0, 0.0);
                    }
                }
                if (hasSpeedMods) {
                    level.method_8406((class_2394)class_2398.field_11249, player.method_23322(0.5), player.method_23318() + 2.5, player.method_23325(0.5), 0.5, 0.0, 0.0);
                }
            }
            if (m.field_1351 < -0.05) {
                player.method_18799(new class_243(m.field_1352, -0.05, m.field_1350));
            }
            return;
        }
        if (GliderUtil.isFlyingBlocked(player)) {
            GliderItem.setGlide(glider, false);
            GliderItem.setStruck(glider, false);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                new MessagePOV("").send(serverPlayer);
            }
        }
    }

    private static void handleNetherLogic(class_1937 level, class_1309 player, class_1799 glider) {
        if (level.method_27983() == class_1937.field_25180 && !GliderItem.hasNetherUpgrade(glider) && player.method_37908().field_9229.method_43048(24) == 0 && !player.method_5701()) {
            player.method_37908().method_8486(player.method_23317() + 0.5, player.method_23318() + 0.5, player.method_23321() + 0.5, class_3417.field_14734, player.method_5634(), 1.0f + level.field_9229.method_43057(), level.field_9229.method_43057() * 0.7f + 0.3f, false);
            for (int i = 0; i < 2; ++i) {
                level.method_8406((class_2394)class_2398.field_11237, player.method_23322(0.5), player.method_23318() + 2.5, player.method_23325(0.5), 0.2, 1.0, 0.0);
                level.method_8406((class_2394)class_2398.field_11251, player.method_23322(0.5), player.method_23318() + 2.5, player.method_23325(0.5), 0.0, 0.2, 0.0);
                level.method_8406((class_2394)class_2398.field_11239, player.method_23322(0.5), player.method_23318() + 2.5, player.method_23325(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    private static void lightningLogic(class_1937 level, class_1309 player, class_1799 glider) {
        if (level.method_8520(player.method_24515())) {
            GliderData.get(player).ifPresent(gliderData -> {
                gliderData.setLightningTimer(gliderData.lightningTimer() + 1);
                if (gliderData.lightningTimer() == 1) {
                    player.method_43077((class_3414)SoundRegistry.INCOMING_LIGHTNING.get());
                }
                if (player.method_37908().field_9229.method_43048(24) == 0 && gliderData.lightningTimer() > 200 && !GliderItem.hasBeenStruck(glider)) {
                    class_1538 lightningBolt = new class_1538(class_1299.field_6112, level);
                    lightningBolt.method_5814(player.method_23317(), player.method_23318(), player.method_23321());
                    lightningBolt.method_29498(false);
                    level.method_8649((class_1297)lightningBolt);
                }
            });
            if (player.method_37908().field_9229.method_43048(24) == 0 && !GliderItem.hasCopperUpgrade(glider)) {
                for (int i = 0; i < 2; ++i) {
                    level.method_8406((class_2394)class_2398.field_29642, player.method_23322(0.5), player.method_23318() + 2.5, player.method_23325(0.5), 0.2, 1.0, 0.0);
                    level.method_8406((class_2394)class_2398.field_29643, player.method_23322(0.5), player.method_23318() + 2.5, player.method_23325(0.5), 0.0, 0.2, 0.0);
                    level.method_8406((class_2394)class_2398.field_22249, player.method_23322(0.5), player.method_23318() + 2.5, player.method_23325(0.5), 0.0, 0.0, 0.0);
                }
            }
        } else {
            GliderData.get(player).ifPresent(gliderData -> gliderData.setLightningTimer(0));
        }
    }

    public static boolean checkUpdraft(class_1937 world, class_1309 player) {
        class_238 boundingBox = player.method_5829().method_1002(2.0, 20.0, 2.0);
        List blocks = world.method_29556(boundingBox).toList();
        Stream<class_2680> filteredBlocks = blocks.stream().filter(blockState -> blockState.method_26164(VCGliderTags.UPDRAFT_BLOCKS) && GliderUtil.checkLit(blockState));
        if (filteredBlocks.toList().size() > 0 || GliderUtil.nearUpdraft(player)) {
            player.method_18800(0.0, 0.5, 0.0);
            return true;
        }
        return false;
    }

    private static boolean checkLit(class_2680 blockState) {
        if (blockState.method_28498((class_2769)class_2741.field_12548)) {
            return (Boolean)blockState.method_11654((class_2769)class_2741.field_12548);
        }
        return true;
    }

    public static boolean isFlyingBlocked(class_1309 livingEntity) {
        return livingEntity.method_24828() || livingEntity.method_5799() || livingEntity.method_5869() || livingEntity.method_5681() || livingEntity.method_6128();
    }

    public static boolean isGlidingWithActiveGlider(class_1309 livingEntity) {
        return GliderUtil.hasGliderEquipped(livingEntity) && GliderUtil.isGliderActive(livingEntity) && !livingEntity.method_24828() && !livingEntity.method_5799();
    }
}

